/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import org.la4j.LinearAlgebra;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.linear.AbstractSolver;
import org.la4j.linear.LinearSystemSolver;

public class ForwardBackSubstitutionSolver
extends AbstractSolver
implements LinearSystemSolver {
    private static final long serialVersionUID = 4071505L;
    private final Matrix lu;
    private final Matrix p;

    public ForwardBackSubstitutionSolver(Matrix a) {
        super(a);
        MatrixDecompositor decompositor = a.withDecompositor(LinearAlgebra.RAW_LU);
        Matrix[] lup = decompositor.decompose();
        this.lu = lup[0];
        this.p = lup[1];
    }

    @Override
    public Vector solve(Vector b) {
        int i;
        int j;
        this.ensureRHSIsCorrect(b);
        int n = this.unknowns();
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.lu.get(i2, i2) != 0.0) continue;
            this.fail("This system can not be solved: coefficient matrix is singular.");
        }
        Vector x = b.blankOfLength(n);
        block1: for (int i3 = 0; i3 < n; ++i3) {
            for (int j2 = 0; j2 < n; ++j2) {
                if (this.p.get(i3, j2) == 0.0) continue;
                x.set(i3, b.get(j2));
                continue block1;
            }
        }
        for (j = 0; j < n; ++j) {
            for (i = j + 1; i < n; ++i) {
                x.updateAt(i, Vectors.asMinusFunction(x.get(j) * this.lu.get(i, j)));
            }
        }
        for (j = n - 1; j >= 0; --j) {
            x.updateAt(j, Vectors.asDivFunction(this.lu.get(j, j)));
            for (i = 0; i < j; ++i) {
                x.updateAt(i, Vectors.asMinusFunction(x.get(j) * this.lu.get(i, j)));
            }
        }
        return x;
    }

    @Override
    public boolean applicableTo(Matrix matrix) {
        return matrix.rows() == matrix.columns();
    }
}

