/*
 * Decompiled with CFR 0.152.
 */
package synapse;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.util.Utils;
import synapse.Util;

public class BotState
implements Cloneable {
    Point2D.Double location;
    double heading;
    double velocity;
    double danger;
    long time;
    int clockwise;

    public BotState(Point2D.Double location, double heading, double velocity, int clockwise, long time) {
        this.location = (Point2D.Double)location.clone();
        this.heading = heading;
        this.velocity = velocity;
        this.clockwise = clockwise;
        this.time = time;
    }

    public BotState(AdvancedRobot r) {
        this.location = new Point2D.Double(r.getX(), r.getY());
        this.heading = r.getHeadingRadians();
        this.velocity = r.getVelocity();
        this.clockwise = 1;
        this.time = r.getTime();
    }

    public BotState iterate(double heading) {
        int forward = this.velocity < 0.0 ? -1 : 1;
        double relativeHeading = Utils.normalRelativeAngle((double)(heading - this.heading));
        double headingChange = Util.backAsFrontTurn(relativeHeading);
        headingChange = Util.limit(-Rules.MAX_TURN_RATE_RADIANS, headingChange, Rules.MAX_TURN_RATE_RADIANS);
        int bafAhead = Util.backAsFrontAhead(relativeHeading);
        double accel = bafAhead == forward ? 1.0 : -2.0;
        double velocity = Util.limit(-8.0, this.velocity + (double)forward * accel, 8.0);
        Point2D.Double location = new Point2D.Double(this.location.x + velocity * Math.sin(this.heading + headingChange), this.location.y + velocity * Math.cos(this.heading + headingChange));
        return new BotState(location, this.heading + headingChange, velocity, this.clockwise, this.time + 1L);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        return (int)this.location.x + "/" + (int)this.location.y;
    }
}

