/*
 * Decompiled with CFR 0.152.
 */
package yarhoslav;

import java.util.Map;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import yarhoslav.Disparo;
import yarhoslav.Entidad;

public class Enemigo
extends Entidad {
    private double mDelta;
    private double mDistancia;
    private double mEnergiaAnterior;

    public Enemigo(Map pContexto) {
        super(pContexto);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.setTurno(e.getTime());
        this.setDir(e.getHeading());
        this.setVel(e.getVelocity());
        this.mEnergiaAnterior = this.getEnergia();
        this.setEnergia(e.getEnergy());
        this.setNombre(e.getName());
        this.mDelta = e.getBearing();
        this.mDistancia = e.getDistance();
        AdvancedRobot lRobot = (AdvancedRobot)this.getContexto().get("PARENT");
        double lAbsDelta = Utils.normalAbsoluteAngleDegrees((double)(lRobot.getHeading() + this.mDelta));
        this.setPosX(lRobot.getX() + Math.sin(Math.toRadians(lAbsDelta)) * this.mDistancia);
        this.setPosY(lRobot.getY() + Math.cos(Math.toRadians(lAbsDelta)) * this.mDistancia);
        Map lEntidades = (Map)this.getContexto().get("ENTIDADES");
        lEntidades.putIfAbsent(this.getNombre(), this);
    }

    public double getDelta() {
        return this.mDelta;
    }

    public double getDistancia() {
        return this.mDistancia;
    }

    @Override
    public void ejecutar() {
        double lDeltaEnergia = this.mEnergiaAnterior - this.getEnergia();
        if (lDeltaEnergia > 0.1) {
            AdvancedRobot lRobot = (AdvancedRobot)this.getContexto().get("PARENT");
            double lAbsDelta = Utils.normalAbsoluteAngleDegrees((double)(lRobot.getHeading() + this.mDelta + 180.0));
            Disparo lDisparo = new Disparo(this.getContexto());
            lDisparo.setNombre("DISPARO" + this.getTurno());
            lDisparo.setEnergia(lDeltaEnergia);
            lDisparo.setVel(Rules.getBulletSpeed((double)lDeltaEnergia));
            lDisparo.setTurno(this.getTurno());
            lDisparo.setDir(lAbsDelta);
            lDisparo.setPosX(this.getPosX());
            lDisparo.setPosY(this.getPosY());
            lDisparo.setTiempoVida(Math.abs(Math.round(this.getDistancia() / this.getVel())));
            lRobot.out.println("ENEMIGO_EJECUTAR: BALA: " + lDisparo.getNombre() + " Entra al juego. A: " + lDisparo.getDir() + " X:" + lDisparo.getPosX() + " Y:" + lDisparo.getPosY());
            Map lEntidades = (Map)this.getContexto().get("ENTIDADES");
            lEntidades.put(lDisparo.getNombre(), lDisparo);
        }
    }
}

