/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.gun;

import catcat20.core.bot.Bot;
import catcat20.core.bot.BotState;
import catcat20.core.gun.Gun;
import catcat20.core.gun.VirtualBullet;
import catcat20.core.gun.perceptual.AntiSurferFirstShot;
import catcat20.core.gun.pif.PlayItForward;
import catcat20.core.gun.waveGun.GunWave;
import catcat20.core.gun.waveGun.WaveGun;
import catcat20.core.gun.waveGun.formula.AntiSurferGunFormula;
import catcat20.core.gun.waveGun.formula.GunKNNModel;
import catcat20.core.move.Surfing;
import catcat20.core.radar.Radar;
import catcat20.core.utils.LConstants;
import catcat20.core.utils.LUtils;
import catcat20.core.utils.MovementPredictor;
import catcat20.core.utils.PreciseWallSmooth;
import catcat20.core.utils.ShadowBullet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.Rules;
import robocode.TeamRobot;
import robocode.util.Utils;

public class LambdaGun {
    public TeamRobot _robot;
    public static PlayItForward meleeGun;
    public static AntiSurferFirstShot firstShotGun;
    public static ArrayList<ShadowBullet> realBullets;
    public ArrayList<GunWave> waves;
    public ArrayList<Gun> guns;
    public ArrayList<WaveGun> waveGuns;
    public double duelLostPower = 0.0;
    public double duelGetPower = 0.0;
    public double meleeLostPower = 0.0;
    public double meleeGetPower = 0.0;
    public Point2D.Double _myPos;
    public static Gun currentBestGun;
    public static Gun previousBestGun;
    public double duelCurrentBestAngle;
    public ArrayList<VirtualBullet> virtualBullets;
    public ArrayList<VirtualBullet> vbCache;
    Rectangle2D.Double rect = new Rectangle2D.Double();
    Color transGray = new Color(0.75f, 0.75f, 0.75f, 0.75f);
    GunWave lastWave = null;
    public static boolean drawMEA;
    Color whiteRed = new Color(255, 180, 180);
    Color whiteBlue = new Color(180, 180, 255);
    PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();

    public LambdaGun(TeamRobot _robot) {
        this._robot = _robot;
        meleeGun = new PlayItForward(_robot);
        firstShotGun = new AntiSurferFirstShot(_robot);
        this.guns = new ArrayList();
        this.waveGuns = new ArrayList();
        WaveGun mainGun = new WaveGun(_robot, Color.red, "Main Gun", false);
        this.guns.add(mainGun);
        this.waveGuns.add(mainGun);
        WaveGun asGun = new WaveGun(_robot, Color.blue, "AntiSurfer Gun", true);
        this.guns.add(asGun);
        this.waveGuns.add(asGun);
        PlayItForward playItForwardGun = new PlayItForward(_robot);
        this.guns.add(playItForwardGun);
        currentBestGun = this.guns.get(0);
    }

    public void init() {
        this._myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        realBullets = new ArrayList();
        this.virtualBullets = new ArrayList();
        this.vbCache = new ArrayList();
        this.waves = new ArrayList();
        this.duelLostPower = 0.0;
        this.duelGetPower = 0.0;
        this.meleeLostPower = 0.0;
        this.meleeGetPower = 0.0;
        meleeGun.init();
        for (Gun gun : this.guns) {
            gun.init();
        }
        System.out.println("Using: " + currentBestGun.getLabel());
    }

    public void updateVirtualBullet() {
        long time = this._robot.getTime();
        Graphics2D g = this._robot.getGraphics();
        for (int i = 0; i < this.virtualBullets.size(); ++i) {
            VirtualBullet bullet = this.virtualBullets.get(i);
            Point2D.Double pos = bullet.simulatePos(time + 1L);
            g.setColor(bullet.gun.getColor());
            int radius = 2;
            g.fillOval((int)pos.x - radius, (int)pos.y - radius, radius * 2, radius * 2);
            this.rect.setRect(bullet.bot.currentState.x - 18.0, bullet.bot.currentState.y - 18.0, 36.0, 36.0);
            if (this.rect.contains(bullet.simulatePos(time + 1L))) {
                bullet.bot.virtualGunHitCount.put(bullet.gun, bullet.bot.virtualGunHitCount.get(bullet.gun) + 1.0);
                this.virtualBullets.remove(i);
                --i;
                continue;
            }
            if (LConstants.field.contains(pos)) continue;
            this.virtualBullets.remove(i);
            --i;
        }
    }

    public void updateWave() {
        Graphics2D g = this._robot.getGraphics();
        long time = this._robot.getTime();
        Bot bot = Radar.nearestBot;
        double botWidth = 12.5;
        for (int i = 0; i < this.waves.size(); ++i) {
            GunWave w = this.waves.get(i);
            if (bot == null || bot.currentState == null || !bot.isAlive) continue;
            if (w.distance(bot.currentState.x, bot.currentState.y) + botWidth >= w.getDistanceTraveled(time) && w.distance(bot.currentState.x, bot.currentState.y) - botWidth <= w.getDistanceTraveled(time)) {
                double gf = w.guessFactor(LUtils.absoluteBearing(this._myPos.x, this._myPos.y, bot.currentState.x, bot.currentState.y));
                w.minGuessFactor = Math.min(w.minGuessFactor, gf);
                w.maxGuessFactor = Math.max(w.maxGuessFactor, gf);
                double guessAngle = (double)w.direction * Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(this._myPos.x, this._myPos.y, bot.currentState.x, bot.currentState.y) - w.directAngle));
                double preciseGF = 0.0;
                preciseGF = guessAngle >= 0.0 ? guessAngle / w.meas[0] : -guessAngle / w.meas[1];
                w.preciseMinGuessFactor = Math.min(w.preciseMinGuessFactor, preciseGF);
                w.preciseMaxGuessFactor = Math.max(w.preciseMaxGuessFactor, preciseGF);
                continue;
            }
            if (!(w.distance(bot.currentState.x, bot.currentState.y) + botWidth < w.getDistanceTraveled(time))) continue;
            for (WaveGun gun : this.waveGuns) {
                gun.logHit(w);
            }
            this.waves.remove(i);
            --i;
        }
    }

    public void duel() {
        GunWave w = null;
        Bot bot = Radar.nearestBot;
        if (bot != null && bot.currentState != null && bot.isAlive && bot.states.size() > 2) {
            BotState last120 = bot.states.get(LUtils.limit(0, bot.states.size() - 1, 120));
            double dist120 = bot.currentState.distance(last120.x, last120.y);
            BotState last60 = bot.states.get(LUtils.limit(0, bot.states.size() - 1, 60));
            double dist60 = bot.currentState.distance(last60.x, last60.y);
            BotState last30 = bot.states.get(LUtils.limit(0, bot.states.size() - 1, 30));
            double dist30 = bot.currentState.distance(last30.x, last30.y);
            BotState last16 = bot.states.get(LUtils.limit(0, bot.states.size() - 1, 16));
            double dist16 = bot.currentState.distance(last16.x, last16.y);
            BotState last8 = bot.states.get(LUtils.limit(0, bot.states.size() - 1, 8));
            double dist8 = bot.currentState.distance(last8.x, last8.y);
            double power = Radar.getFirePower();
            int direction = LUtils.sign(Bot.lateralVelocity(Radar.myState, bot.currentState));
            double directAngle = LUtils.absoluteBearing(this._myPos.x, this._myPos.y, bot.currentState.x, bot.currentState.y);
            w = new GunWave(this._myPos.x, this._myPos.y, directAngle, direction, power, this._robot.getTime() + 1L, false, bot.currentState, bot.states.get(1), Radar.myState, Radar.myStates.get(1));
            w.dist8 = dist8;
            w.dist16 = dist16;
            w.dist30 = dist30;
            w.dist60 = dist60;
            w.dist120 = dist120;
            w.dirChangeTime = bot.dirChangeTimeFromMe;
            w.meas = this.getMea(power, bot.currentState, Radar.myState.x, Radar.myState.y, 0L, direction, this._robot.getGraphics());
            LambdaGun.firstShotGun.lastWave = w;
            this.lastWave = w;
            this.waves.add(w);
            this.updateWave();
            for (WaveGun gun : this.waveGuns) {
                gun.setWave(w);
            }
            double bestHit = Double.NEGATIVE_INFINITY;
            for (Gun gun : this.guns) {
                if (!bot.virtualGunHitCount.containsKey(gun)) {
                    bot.virtualGunHitCount.put(gun, 0.0);
                    bot.virtualGunFireCount.put(gun, 0.0);
                }
                double hit = bot.virtualGunHitCount.get(gun);
                double fire = bot.virtualGunFireCount.get(gun);
                if (hit > bestHit) {
                    currentBestGun = gun;
                    bestHit = hit;
                }
                gun.execute();
                double angle = gun.getAngle(power);
                VirtualBullet virtualBullet = new VirtualBullet(Surfing.nextMyPos.x, Surfing.nextMyPos.y, angle, power, this._robot.getTime() + 1L, gun, bot);
                this.vbCache.add(virtualBullet);
                if (currentBestGun != gun) continue;
                this.duelCurrentBestAngle = angle;
            }
            if (currentBestGun != previousBestGun) {
                System.out.println("Switching to " + currentBestGun.getLabel());
            }
        }
    }

    public double[] getMea(double power, BotState en, double myX, double myY, long time, int direction, Graphics2D g) {
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.x, en.y, en.heading, en.velocity, time);
        double absBearing = LUtils.absoluteBearing(myX, myY, en.x, en.y);
        double distance = Point2D.Double.distance(myX, myY, en.x, en.y);
        double bft = distance / Rules.getBulletSpeed((double)power);
        int count = (int)bft;
        MovementPredictor.PredictionStatus dir1 = (MovementPredictor.PredictionStatus)status.clone();
        double distTravel1 = 0.0;
        for (int i = 0; i < count; ++i) {
            distTravel1 += Rules.getBulletSpeed((double)power);
            double dist1 = Point2D.Double.distance(myX, myY, dir1.x, dir1.y);
            if (!(dist1 - distTravel1 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir1.x, dir1.y, myX, myY) + 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir1.x, dir1.y, -1 * direction);
            dir1 = MovementPredictor.predict(dir1, angle, 8.0);
            if (g == null || !drawMEA) continue;
            g.setColor(this.whiteRed);
            g.drawOval((int)dir1.x - 1, (int)dir1.y - 1, 2, 2);
        }
        double distTravel2 = 0.0;
        MovementPredictor.PredictionStatus dir2 = (MovementPredictor.PredictionStatus)status.clone();
        for (int i = 0; i < count; ++i) {
            distTravel2 += Rules.getBulletSpeed((double)power);
            double dist2 = Point2D.Double.distance(myX, myY, dir2.x, dir2.y);
            if (!(dist2 - distTravel2 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir2.x, dir2.y, myX, myY) - 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir2.x, dir2.y, direction);
            dir2 = MovementPredictor.predict(dir2, angle, 8.0);
            if (g == null || !drawMEA) continue;
            g.setColor(this.whiteBlue);
            g.drawOval((int)dir2.x - 1, (int)dir2.y - 1, 2, 2);
        }
        double mea1 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir1.x, dir1.y) - absBearing));
        double mea2 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir2.x, dir2.y) - absBearing));
        if (g != null && drawMEA) {
            g.setColor(this.whiteRed);
            Point2D.Double test1 = LUtils.project(this._myPos, mea1 + absBearing, 1000.0);
            g.drawLine((int)this._myPos.x, (int)this._myPos.y, (int)test1.x, (int)test1.y);
            g.setColor(this.whiteBlue);
            test1 = LUtils.project(this._myPos, mea2 + absBearing, 1000.0);
            g.drawLine((int)this._myPos.x, (int)this._myPos.y, (int)test1.x, (int)test1.y);
        }
        return new double[]{mea1, mea2};
    }

    public void melee() {
        meleeGun.execute();
    }

    public void onTick() {
        double epsilon;
        double angle;
        this.vbCache.clear();
        this._myPos.setLocation(this._robot.getX(), this._robot.getY());
        this._myPos.setLocation(Surfing.nextMyPos);
        int others = this._robot.getOthers();
        this.updateVirtualBullet();
        if (others > 1) {
            this.melee();
        } else {
            this.duel();
        }
        double firePower = Radar.getFirePower();
        double shadowAngle = Double.NaN;
        boolean shadowGun = false;
        if (!Double.isNaN(shadowAngle)) {
            firePower = 0.1;
            shadowGun = true;
        }
        boolean doTurnGun = false;
        if (this._robot.getGunHeat() <= LConstants.GUN_COOLING_RATE * 3.0) {
            doTurnGun = true;
        } else if (Radar.nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null && others <= 1 && Radar.nearestBot.currentState.distance(this._myPos.x, this._myPos.y) <= 250.0) {
            doTurnGun = true;
        }
        if (doTurnGun) {
            angle = 0.0;
            angle = others > 1 ? meleeGun.getAngle(firePower) : (shadowGun ? shadowAngle : (firstShotGun != null && this._robot.getRoundNum() <= 0 && this._robot.getTime() <= 100L ? firstShotGun.getAngle(firePower) : this.duelCurrentBestAngle));
            epsilon = Utils.getRandom().nextDouble(-1.0E-12, 1.0E-12);
            this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)((angle += epsilon) - this._robot.getGunHeadingRadians())));
        } else if (Radar.nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null && (others <= 1 || !(Radar.nearestBot.currentState.distance(this._myPos.x, this._myPos.y) > 100.0)) && others <= 1) {
            angle = LUtils.absoluteBearing(this._myPos.x, this._myPos.y, Radar.nearestBot.currentState.x, Radar.nearestBot.currentState.y);
            epsilon = Utils.getRandom().nextDouble(-1.0E-12, 1.0E-12);
            this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)((angle += epsilon) - this._robot.getGunHeadingRadians())));
        }
        if (Radar.nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null && others <= 1 && Radar.nearestBot.currentState.distance(this._myPos.x, this._myPos.y) <= 80.0) {
            angle = LUtils.absoluteBearing(this._myPos.x, this._myPos.y, Radar.nearestBot.currentState.x, Radar.nearestBot.currentState.y);
            epsilon = Utils.getRandom().nextDouble(-1.0E-12, 1.0E-12);
            this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)((angle += epsilon) - this._robot.getGunHeadingRadians())));
        }
        Bullet bullet = null;
        if (doTurnGun && this._robot.getGunTurnRemaining() < 1.0) {
            if (others <= 1) {
                if (this._robot.getEnergy() > firePower + 0.15 || LConstants.TC_MODE) {
                    bullet = this._robot.setFireBullet(firePower);
                }
            } else if ((this._robot.getEnergy() > firePower + 0.15 || LConstants.TC_MODE) && Radar.nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null) {
                bullet = this._robot.setFireBullet(firePower);
            }
        } else if (!(Radar.nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null && others <= 1 && Radar.nearestBot.currentState.distance(this._myPos.x, this._myPos.y) <= 100.0 && this._robot.getEnergy() > firePower + 0.15 && (bullet = this._robot.setFireBullet(firePower)) == null)) {
            // empty if block
        }
        if (bullet != null) {
            if (others <= 1 && Radar.nearestBot != null) {
                ++Radar.nearestBot.shotsFiredDuel;
            }
            if (this.lastWave != null) {
                this.lastWave.isRealWave = true;
            }
            realBullets.add(new ShadowBullet(bullet.getX(), bullet.getY(), this._robot.getTime(), bullet.getVelocity(), bullet.getHeadingRadians()));
            if (others <= 1) {
                this.duelLostPower += bullet.getPower();
            } else {
                this.meleeLostPower += bullet.getPower();
            }
            this.virtualBullets.addAll(this.vbCache);
            for (VirtualBullet vb : this.vbCache) {
                vb.bot.virtualGunFireCount.put(vb.gun, vb.bot.virtualGunFireCount.get(vb.gun) + 1.0);
            }
        }
        previousBestGun = currentBestGun;
    }

    public void endTask() {
        System.out.println();
        System.out.println("duel lost: " + this.duelLostPower);
        System.out.println("duel get: " + this.duelGetPower);
        System.out.println();
        System.out.println("melee lost: " + this.meleeLostPower);
        System.out.println("melee get: " + this.meleeGetPower);
        System.out.println();
        for (Bot bot : Radar.enemyList) {
            for (Gun gun : this.guns) {
                if (!bot.virtualGunHitCount.containsKey(gun)) continue;
                double hit = bot.virtualGunHitCount.get(gun);
                double fire = bot.virtualGunFireCount.get(gun);
                System.out.println("[" + bot.name + "] " + gun.getLabel() + ": " + hit + " / " + fire + "  (" + 100.0 * hit / fire + "%)");
            }
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (this._robot.getOthers() <= 1) {
            this.duelGetPower += Rules.getBulletHitBonus((double)e.getBullet().getPower());
            Bot bot = Radar.getBot(e.getName());
            if (bot != null && bot.currentState != null) {
                bot.antiSurferModel = new GunKNNModel(new AntiSurferGunFormula());
            }
        } else {
            this.meleeGetPower += Rules.getBulletHitBonus((double)e.getBullet().getPower());
        }
    }

    public void onPaint(Graphics2D g) {
        if (this._robot.getOthers() > 1) {
            meleeGun.onPaint(g);
        } else {
            for (Gun gun : this.guns) {
                gun.onPaint(g);
            }
        }
    }

    static {
        drawMEA = true;
    }
}

