/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.painting;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Arrays;

public class GFPainter {
    private static void normalizePeakBuffer(double[] b) {
        double low = b[0];
        double high = b[0];
        double[] dArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (v > high) {
                high = v;
            }
            if (v < low) {
                low = v;
            }
            ++n2;
        }
        double size = high - low;
        if (size == 0.0) {
            return;
        }
        int x = 0;
        while (x < b.length) {
            b[x] = (b[x] - low) / size;
            ++x;
        }
    }

    public static void paintTargetingProfile(Graphics2D g, int x, int y, double[] b) {
        if (b == null) {
            return;
        }
        double[] bins = Arrays.copyOf(b, b.length);
        GFPainter.normalizePeakBuffer(bins);
        int xoff = x + 1;
        int yoff = y + 1 + 10;
        int height = 80;
        int width = (bins.length + 2) * 5 + xoff - x + 1;
        width -= xoff + x - 1;
        height -= yoff + y - 1;
        g.setColor(new Color(255, 255, 0, 200));
        int i = 0;
        while (i < bins.length) {
            int y2;
            int y1 = y2 = yoff + (int)((double)height * bins[i]);
            int x1 = xoff + i * 5;
            int x2 = x1 + 4;
            g.drawLine(x1, y1, x2, y2);
            ++i;
        }
        g.setColor(new Color(255, 255, 255, 50));
        g.drawRect(xoff - 1, yoff - 1, width + 2, height + 2);
    }
}

