/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVectorImpl;

public class StaticPositionImpl
implements StaticPosition {
    public static final StaticPosition anchor = new StaticPositionImpl(0.0, 0.0);
    private final double x;
    private final double y;

    public StaticPositionImpl(double newX, double newY) {
        this.x = newX;
        this.y = newY;
    }

    public StaticPositionImpl(StaticPosition other) {
        this.x = other.getX();
        this.y = other.getY();
    }

    public StaticPositionImpl(double _x, double _y, StaticPosition offset) {
        this.x = _x + offset.getX();
        this.y = _y + offset.getY();
    }

    public StaticPositionImpl(StaticPosition origin, StaticPosition offset) {
        this.x = origin.getX() + offset.getX();
        this.y = origin.getY() + offset.getY();
    }

    public StaticPositionImpl(double _x, double _y, double angle, double distance) {
        this.x = _x + StaticPositionImpl.calculateDeltaX(angle, distance);
        this.y = _y + StaticPositionImpl.calculateDeltaY(angle, distance);
    }

    public StaticPositionImpl(StaticPosition origin, double angle, double distance) {
        this.x = origin.getX() + StaticPositionImpl.calculateDeltaX(angle, distance);
        this.y = origin.getY() + StaticPositionImpl.calculateDeltaY(angle, distance);
    }

    public StaticPositionImpl(StaticPosition origin, StaticVector vector) {
        this.x = origin.getX() + StaticPositionImpl.calculateDeltaX(vector.getHeading(), vector.getVelocity());
        this.y = origin.getY() + StaticPositionImpl.calculateDeltaY(vector.getHeading(), vector.getVelocity());
    }

    public StaticPositionImpl(StaticVector vector) {
        this.x = StaticPositionImpl.calculateDeltaX(vector.getHeading(), vector.getVelocity());
        this.y = StaticPositionImpl.calculateDeltaY(vector.getHeading(), vector.getVelocity());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean equalsPosition(StaticPosition other) {
        return other == null ? false : Constraints.isApproximatelyZero(this.getDistance(other));
    }

    public double getDistance(StaticPosition other) {
        return StaticPositionImpl.getAbsDistance(other.getX() - this.getX(), other.getY() - this.getY());
    }

    public double getBearing(StaticPosition other) {
        return StaticPositionImpl.getBearing(other.getX() - this.getX(), other.getY() - this.getY());
    }

    public StaticPosition getRelativePosition(StaticPosition other) {
        return new StaticPositionImpl(other.getX() - this.x, other.getY() - this.y);
    }

    public StaticVector getRelativeVector(StaticPosition other, double relativeHeading) {
        StaticVectorImpl relativeVector = this.equalsPosition(other) ? new StaticVectorImpl(relativeHeading, 0.0) : new StaticVectorImpl(this.getBearing(other), this.getDistance(other));
        return relativeVector;
    }

    public static double getBearing(double deltaX, double deltaY) {
        double bearing = 0.0;
        if (deltaY == 0.0) {
            bearing = deltaX < 0.0 ? 4.71238898038469 : 1.5707963267948966;
        } else {
            bearing = Math.atan(deltaX / deltaY);
            if (deltaY < 0.0) {
                bearing += Math.PI;
            }
        }
        return Constraints.getZeroToTwoPi(bearing);
    }

    public static double getAbsDistance(double deltaX, double deltaY) {
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public static double calculateDeltaX(double angle, double length) {
        return Math.sin(angle) * length;
    }

    public static double calculateDeltaY(double angle, double length) {
        return Math.cos(angle) * length;
    }

    public void debug() {
        Debug.debug(this.toString());
    }

    public String toString() {
        return "( " + Debug.trim(this.x) + ", " + Debug.trim(this.y) + " )";
    }
}

