/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.RobotDataStore;

public class GunPhysics {
    private final RobotDataStore mDataStore = RobotDataStore.getInstance();
    private double mCoolingRate = 0.1;
    private static GunPhysics THE_INSTANCE = new GunPhysics();

    private GunPhysics() {
    }

    public static GunPhysics getInstance() {
        return THE_INSTANCE;
    }

    public void setCoolingRate(double coolingRate) {
        this.mCoolingRate = coolingRate;
    }

    public double getCoolingRate() {
        return this.mCoolingRate;
    }

    public boolean amIReadyToFire() {
        boolean answer = false;
        double gunHeat = this.mDataStore.getMyGunHeat();
        if (gunHeat < 0.01) {
            answer = true;
        }
        return answer;
    }

    public long howLongTillReadyAfter(double shotPower) {
        double numTurns = (1.0 + shotPower / 5.0) / this.mCoolingRate;
        numTurns = -1.0 * Math.floor(-1.0 * numTurns);
        return (long)numTurns;
    }

    public long howLongUntilICanFire() {
        double gunHeat = this.mDataStore.getMyGunHeat();
        double numTurns = gunHeat / this.mCoolingRate;
        numTurns = -1.0 * Math.floor(-1.0 * numTurns);
        return (long)numTurns;
    }

    public static final double shotPwrFromSpd(double speed) {
        double power = -1.0;
        if (speed >= 0.0) {
            power = (20.0 - speed) / 3.0;
        }
        return power;
    }

    public static final double shotSpdFromPwr(double power) {
        double speed = -1.0;
        if (power >= 0.0) {
            speed = 20.0 - 3.0 * power;
        }
        return speed;
    }

    public static final double minLegalPwr() {
        return 0.1;
    }

    public static final double maxLegalPwr() {
        return 3.0;
    }

    public static final double minLegalSpd() {
        return GunPhysics.shotSpdFromPwr(GunPhysics.maxLegalPwr());
    }

    public static final double maxLegalSpd() {
        return GunPhysics.shotSpdFromPwr(GunPhysics.minLegalPwr());
    }

    public static final double dmgFromPwr(double power) {
        double damage = 4.0 * power;
        if (power > 1.0) {
            damage += 2.0 * (power - 1.0);
        }
        return damage;
    }

    public static final double pwrFromDmg(double damage) {
        double power = -1.0;
        power = damage > 4.0 ? (damage + 2.0) / 6.0 : damage / 4.0;
        return power;
    }
}

