/*
 * Decompiled with CFR 0.152.
 */
package kid.virtual;

import kid.data.Data;
import kid.graphics.RGraphics;
import kid.robot.RobotData;
import kid.segmentation.Segmentable;
import kid.utils.Utils;
import kid.virtual.VirtualWave;
import robocode.Bullet;
import robocode.Robot;

public class DataWave<E extends Data, F extends Segmentable, G extends Segmentable>
extends VirtualWave {
    private static final long serialVersionUID = 4650614154195009930L;
    protected E[] data;
    protected F view;
    protected G reference;

    public DataWave(double startX, double startY, double heading, double firePower, long creationTime, E[] data, F view, G reference) {
        super(startX, startY, heading, firePower, creationTime);
        this.init((Data[])data, (Segmentable)view, (Segmentable)reference);
    }

    public DataWave(Bullet bullet, RobotData firer, RobotData target, E[] data, F view, G reference) {
        super(firer.getX(), firer.getY(), Utils.angle(firer.getX(), firer.getY(), target.getX(), target.getY()), bullet.getPower(), firer.getTime());
        this.init((Data[])data, (Segmentable)view, (Segmentable)reference);
    }

    public DataWave(RobotData firer, RobotData target, double firePower, E[] data, F view, G reference) {
        super(firer.getX(), firer.getY(), Utils.angle(firer.getX(), firer.getY(), target.getX(), target.getY()), firePower, firer.getTime());
        this.init((Data[])data, (Segmentable)view, (Segmentable)reference);
    }

    public DataWave(Robot firer, RobotData target, double firePower, E[] data, F view, G reference) {
        super(firer.getX(), firer.getY(), Utils.angle(firer.getX(), firer.getY(), target.getX(), target.getY()), firePower, firer.getTime());
        this.init((Data[])data, (Segmentable)view, (Segmentable)reference);
    }

    private void init(E[] data, F view, G reference) {
        this.data = data;
        this.view = view;
        this.reference = reference;
    }

    public E[] getData() {
        return this.data;
    }

    public F getView() {
        return this.view;
    }

    public G getReference() {
        return this.reference;
    }

    @Override
    public void draw(RGraphics grid) {
        super.draw(grid);
    }
}

