/*
 * Decompiled with CFR 0.152.
 */
package xander.core.paint;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.List;
import xander.core.Resources;
import xander.core.paint.WavePainter;
import xander.core.track.Wave;
import xander.core.track.WaveHistory;
import xander.core.track.XBulletWave;

public class MyVirtualWavePainter
extends WavePainter {
    private WaveHistory waveHistory;

    public MyVirtualWavePainter(WaveHistory waveHistory) {
        super(Color.GRAY, Color.LIGHT_GRAY, Color.YELLOW);
        this.waveHistory = waveHistory;
    }

    @Override
    protected List<? extends Wave> getWaves() {
        return this.waveHistory.getMyVirtualWaves();
    }

    @Override
    public void onPaint(Graphics2D g) {
        super.onPaint(g);
        long time = Resources.getTime();
        g.setColor(Color.GRAY);
        for (XBulletWave wave : this.waveHistory.getMyVirtualWaves()) {
            if (wave.isPassed()) continue;
            Point2D.Double endPoint = wave.getBulletLocation(time);
            Point2D.Double startPoint = wave.getBulletLocation(time - 1L);
            Line2D.Double bulletIndicator = new Line2D.Double(startPoint, endPoint);
            g.draw(bulletIndicator);
        }
    }
}

