/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

import java.awt.Color;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.ListIterator;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import wcsv.mega.DamageTracker;
import wcsv.mega.GFWave;
import wcsv.mega.Location;
import wcsv.mega.Movement;
import wcsv.mega.MyInfo;
import wcsv.mega.ScanInfo;
import wcsv.mega.ScanManager;
import wcsv.mega.SegAxis;
import wcsv.mega.Utils;
import wcsv.mega.Vector;
import wcsv.mega.WaveBase;

public class PHWaveSurfMove
extends Movement {
    private static final double WAVE_IGNORE_DIST = 50.0;
    private static final double WAVE_BREAK_DIST = -40.0;
    private static final double PREDICTION_WAVE_BREAK = 18.0;
    private static double EVADE_DIST = 50.0;
    private static double PREF_DIST = 450.0;
    private static double DIVE_ANGLE = Math.toRadians(40.0);
    private static final int SURF_DEPTH = 10;
    private SurfPath[] paths;
    private static final int FWD = 0;
    private static final int REV = 1;
    private static final int STOP = 2;
    private static final int PATH_COUNT = 3;
    private int last = 0;
    private LinkedList waves;
    private LinkedList surfWaves;
    private ScanInfo myInfoScans;
    private HitByBulletEvent hitEvent = null;
    private static final double[] gfs = new double[]{-1.0, -0.95, -0.9, -0.85, -0.8, -0.75, -0.7, -0.65, -0.6, -0.55, -0.5, -0.45, -0.4, -0.35, -0.3, -0.25, -0.2, -0.15, -0.1, -0.05, 0.0, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1.0, Double.MAX_VALUE};
    private static final int BINS = gfs.length;
    private static final int MID_BIN = (int)((double)BINS / 2.0);
    SegAxis bftSegs = new SegAxis(10.0, 60.0, 7);
    SegAxis bftSegsFast = new SegAxis(20.0, 60.0, 3);
    SegAxis velocitySegs = new SegAxis(2.0, 6.0, 3);
    SegAxis velocitySegsFast = new SegAxis(2.0, 6.0, 3);
    SegAxis wallSegs = new SegAxis(Math.toRadians(5.0), Math.toRadians(45.0), 5);
    SegAxis wallSegsFast = new SegAxis(Math.toRadians(10.0), Math.toRadians(30.0), 3);
    SegAxis wallSegsRev = new SegAxis(-Math.toRadians(10.0), -Math.toRadians(30.0), 3);
    SegAxis wallSegsRevFast = new SegAxis(-Math.toRadians(15.0), -Math.toRadians(30.0), 2);
    public static final int accelSegs = 3;
    public double[][][][][][] buffer1;
    public double[][][][][][] buffer2;
    public double[][][] buffer3;
    public double[][][][][] buffer4;
    private int num_buffers;
    private int index1;
    private double[] data1;
    private int index2;
    private double[] data2;
    private int index3;
    private double[] data3;
    private int index4;
    private double[] data4;
    private double[] no_seg;
    private static final double WALL_DISTANCE = 20.0;
    private static final double CHECK_DISTANCE = 140.0;

    public PHWaveSurfMove(MyInfo me, ScanManager scans) {
        super(me, scans);
        this.buffer1 = new double[this.bftSegs.segments + 1][3][this.velocitySegs.segments + 1][this.wallSegs.segments + 1][this.wallSegsRev.segments + 1][BINS + 1];
        this.buffer2 = new double[this.bftSegsFast.segments + 1][3][this.velocitySegsFast.segments + 1][this.wallSegsFast.segments + 1][this.wallSegsRevFast.segments + 1][BINS + 1];
        this.buffer3 = new double[this.bftSegs.segments + 1][this.velocitySegs.segments + 1][BINS + 1];
        this.buffer4 = new double[this.bftSegsFast.segments + 1][this.velocitySegsFast.segments + 1][this.wallSegsFast.segments + 1][this.wallSegsRevFast.segments + 1][BINS + 1];
        this.num_buffers = 4;
        this.index1 = 0;
        this.index2 = 1;
        this.index3 = 2;
        this.index4 = 3;
        this.waves = new LinkedList();
        this.myInfoScans = new ScanInfo(3);
        this.paths = new SurfPath[3];
        this.no_seg = new double[BINS + 1];
        this.no_seg[PHWaveSurfMove.MID_BIN] = 1.0;
        this.no_seg[PHWaveSurfMove.BINS] = 1.0;
    }

    private void setBuffers(int[][] i) {
        this.data1 = this.buffer1[i[this.index1][0]][i[this.index1][1]][i[this.index1][2]][i[this.index1][3]][i[this.index1][4]];
        this.data2 = this.buffer2[i[this.index2][0]][i[this.index2][1]][i[this.index2][2]][i[this.index2][3]][i[this.index2][4]];
        this.data3 = this.buffer3[i[this.index3][0]][i[this.index3][1]];
        this.data4 = this.buffer4[i[this.index4][0]][i[this.index4][1]][i[this.index4][2]][i[this.index4][3]];
    }

    private void update(int[][] indexArr, double bin, double weight) {
        this.setBuffers(indexArr);
        int i = 0;
        while (i < BINS) {
            double val = weight / (1.0 + Utils.sqr(bin - (double)i));
            int n = i;
            this.data1[n] = this.data1[n] + val;
            int n2 = i;
            this.data2[n2] = this.data2[n2] + val;
            int n3 = i;
            this.data3[n3] = this.data3[n3] + val;
            int n4 = i;
            this.data4[n4] = this.data4[n4] + val;
            int n5 = i++;
            this.no_seg[n5] = this.no_seg[n5] + val;
        }
        int n = BINS;
        this.data1[n] = this.data1[n] + 1.0;
        int n6 = BINS;
        this.data2[n6] = this.data2[n6] + 1.0;
        int n7 = BINS;
        this.data3[n7] = this.data3[n7] + 1.0;
        int n8 = BINS;
        this.data4[n8] = this.data4[n8] + 1.0;
        int n9 = BINS;
        this.no_seg[n9] = this.no_seg[n9] + 1.0;
    }

    private int[][] getSegments(ScanInfo scan, double bulletVel) {
        int[][] segs = new int[this.num_buffers][];
        segs[this.index1] = new int[]{this.bftSegs.getIndex(scan.last().getDistance() / bulletVel), this.accelIndex(scan.getLatAccel()), this.velocitySegs.getIndex(Math.abs(scan.last().getLatVel())), this.wallSegs.wallIndex(this.me.getLoc(), scan), this.wallSegsRev.wallIndex(this.me.getLoc(), scan)};
        segs[this.index2] = new int[]{this.bftSegsFast.getIndex(scan.last().getDistance() / bulletVel), this.accelIndex(scan.getLatAccel()), this.velocitySegsFast.getIndex(Math.abs(scan.last().getLatVel())), this.wallSegsFast.wallIndex(this.me.getLoc(), scan), this.wallSegsRevFast.wallIndex(this.me.getLoc(), scan)};
        segs[this.index3] = new int[]{this.bftSegs.getIndex(scan.last().getDistance() / bulletVel), this.velocitySegs.getIndex(Math.abs(scan.last().getLatVel()))};
        segs[this.index4] = new int[]{this.bftSegsFast.getIndex(scan.last().getDistance() / bulletVel), this.velocitySegsFast.getIndex(Math.abs(scan.last().getLatVel())), this.wallSegsFast.wallIndex(this.me.getLoc(), scan), this.wallSegsRevFast.wallIndex(this.me.getLoc(), scan)};
        return segs;
    }

    private int accelIndex(double accel) {
        if (accel < 0.0) {
            return 0;
        }
        if (accel > 0.0) {
            return 2;
        }
        return 1;
    }

    private double[] getBuffer(int[][] indexArr) {
        this.setBuffers(indexArr);
        double[] buff = new double[BINS];
        double denom1 = Math.max(this.data1[BINS], 1.0);
        double denom2 = Math.max(this.data2[BINS], 1.0);
        double denom3 = Math.max(this.data3[BINS], 1.0);
        double denom4 = Math.max(this.data4[BINS], 1.0);
        double no_seg_denom = Utils.sqr(Math.max(this.no_seg[BINS], 1.0));
        int i = 0;
        while (i < BINS) {
            int n = i;
            buff[n] = buff[n] + this.data1[i] / denom1;
            int n2 = i;
            buff[n2] = buff[n2] + this.data2[i] / denom2;
            int n3 = i;
            buff[n3] = buff[n3] + this.data3[i] / denom3;
            int n4 = i;
            buff[n4] = buff[n4] + this.data4[i] / denom4;
            int n5 = i;
            buff[n5] = buff[n5] + this.no_seg[i] / no_seg_denom;
            ++i;
        }
        return buff;
    }

    public void onScan(ScanInfo scan) {
        this.myInfoScans.add(this.me, scan.last());
    }

    public void doMove(ScanInfo target) {
        if (this.hitEvent != null) {
            this.proc_hitByBullet(this.hitEvent);
            this.hitEvent = null;
        }
        PREF_DIST = DamageTracker.getBestDistance();
        if (target != null) {
            ListIterator it = this.waves.listIterator();
            while (it.hasNext()) {
                GFWave wv = (GFWave)it.next();
                double dist = wv.distanceTo(this.myInfoScans.last().getLoc(), this.me.getTime());
                if (!(dist < -40.0)) continue;
                it.remove();
            }
            double bulletPower = target.getBulletPower();
            if (bulletPower > 0.0) {
                int[][] segs = this.getSegments(this.myInfoScans, Utils.bulletVel(bulletPower));
                this.waves.add(new GFWave(segs, target.last().getLoc(), this.myInfoScans.get(0).getBearing(), Utils.bulletVel(bulletPower), this.me.getTime() - 2L, this.myInfoScans.get(0).getOrbit(), true));
            }
            this.surfWaves = WaveBase.sortWaves(this.me.getLoc(), this.me.getTime(), 50.0, this.waves);
            double orbit = this.myInfoScans.last().getOrbit();
            this.paths[0] = new SurfPath(orbit != 0.0 ? orbit : 1.0, target, 10, 8.0);
            this.paths[1] = new SurfPath(orbit != 0.0 ? -orbit : -1.0, target, 10, 8.0);
            this.paths[2] = new SurfPath(orbit != 0.0 ? orbit : 1.0, target, 10, 0.0);
            if (this.paths[0].diving() && this.paths[1].diving() || target.last().getDistance() < EVADE_DIST) {
                this.paths[2].setDanger(Double.MAX_VALUE);
            }
            int i = 0;
            while (i < 3) {
                if (this.paths[i].getDanger() < this.paths[this.last].getDanger()) {
                    this.last = i;
                }
                ++i;
            }
            this.moveBot(this.paths[this.last].getPath().getDistance(), this.paths[this.last].getPath().getAngle());
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Location hitLoc = new Location(e.getBullet().getX(), e.getBullet().getY());
        GFWave wv = (GFWave)WaveBase.closestWave(this.waves, hitLoc, this.me.getTime());
        double gf = wv.getOrbit() * wv.bearingChange(hitLoc) / Utils.max_escape(wv.getVelocity());
        gf = Utils.getIndex(gf, gfs);
        this.update(wv.getSegs(), gf, 1.0);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.hitEvent = e;
    }

    public void proc_hitByBullet(HitByBulletEvent e) {
        GFWave wv = (GFWave)WaveBase.closestWave(this.waves, this.me.getLoc(), e.getTime());
        if (wv == null) {
            System.out.println("no wave found");
            return;
        }
        double gf = wv.getOrbit() * wv.bearingChange(this.me.getLoc()) / Utils.max_escape(wv.getVelocity());
        gf = Utils.getIndex(gf, gfs);
        this.update(wv.getSegs(), gf, 1.0);
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    protected void reset(MyInfo newMe, ScanManager newScans) {
        super.reset(newMe, newScans);
        this.waves.clear();
        this.surfWaves.clear();
        this.last = 0;
        this.paths = new SurfPath[3];
        this.hitEvent = null;
    }

    private double wallCorrectedAngle(double angle, Location loc, double orbit) {
        double locWallX = Math.min(loc.getX() - 20.0, this.me.getFWidth() - loc.getX() - 20.0);
        double locWallY = Math.min(loc.getY() - 20.0, this.me.getFHeight() - loc.getY() - 20.0);
        Location dest = loc.project(angle, 140.0);
        double destWallX = Math.min(dest.getX() - 20.0, this.me.getFWidth() - dest.getX() - 20.0);
        double destWallY = Math.min(dest.getY() - 20.0, this.me.getFHeight() - dest.getY() - 20.0);
        double adj = 0.0;
        int i = 0;
        while (Utils.outside_border(dest, 20.0) && i++ < 15) {
            if (destWallX < 0.0 && destWallX < destWallY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + Utils.HALFPI;
                adj = Math.abs(locWallX);
            } else if (destWallY < 0.0 && destWallY <= destWallX) {
                angle = (double)((int)((angle + Utils.HALFPI) / Math.PI)) * Math.PI;
                adj = Math.abs(locWallY);
            }
            dest = loc.project(angle += orbit * (Math.acos(adj / 140.0) + 0.0025), 140.0);
            destWallX = Math.min(dest.getX() - 20.0, this.me.getFWidth() - dest.getX() - 20.0);
            destWallY = Math.min(dest.getY() - 20.0, this.me.getFHeight() - dest.getY() - 20.0);
        }
        return Utils.absAngle(angle);
    }

    private PredictionData nextLocation(PredictionData data, double wantedHeading, double wantedVelocity) {
        int dir = 0;
        double angleToTurn = Utils.relAngle(wantedHeading - data.heading);
        if (Math.abs(angleToTurn) > Utils.HALFPI) {
            dir = -1;
            angleToTurn = angleToTurn > 0.0 ? (angleToTurn -= Utils.PI) : (angleToTurn += Utils.PI);
            angleToTurn = Utils.relAngle(angleToTurn);
        } else {
            dir = 1;
        }
        wantedVelocity = Math.abs(angleToTurn) >= SLOW_ANGLE ? 0.0 : wantedVelocity;
        double tr = Utils.maxTurnRate(data.velocity);
        if (angleToTurn < 0.0) {
            PredictionData predictionData = data;
            predictionData.heading = predictionData.heading - Math.min(tr, Math.abs(angleToTurn));
        } else if (angleToTurn > 0.0) {
            PredictionData predictionData = data;
            predictionData.heading = predictionData.heading + Math.min(tr, Math.abs(angleToTurn));
        }
        data.heading = Utils.absAngle(data.heading);
        if (wantedVelocity == 0.0) {
            if (data.velocity > 0.0) {
                data.velocity = Math.max(wantedVelocity, data.velocity - 2.0);
            } else {
                data.velocity = Math.min(wantedVelocity, data.velocity + 2.0);
            }
        } else if (dir == 1) {
            if (data.velocity < 0.0) {
                data.velocity = Math.min(wantedVelocity, data.velocity + 2.0);
            } else {
                data.velocity = Math.min(wantedVelocity, data.velocity + 1.0);
            }
        } else if (data.velocity > 0.0) {
            data.velocity = Math.max(-wantedVelocity, data.velocity - 2.0);
        } else {
            data.velocity = Math.max(-wantedVelocity, data.velocity - 1.0);
        }
        data.loc = data.loc.project(data.heading, data.velocity);
        return data;
    }

    private void predict(PredictionData data, WaveBase surfw, double wantedOrbit, double wantedVelocity) {
        WaveBase wave = surfw.copy();
        long time = data.getTime();
        while (wave.distanceTo(data.getLoc(), time) > 18.0) {
            ++time;
            double wantedHeading = this.moveHeading(wave.getCenter(), data.getLoc(), wantedOrbit);
            data = this.nextLocation(data, wantedHeading, wantedVelocity);
        }
        data.setTime(time);
    }

    private double distanceHeading(Location center, Location myLoc, double orbit) {
        double offset = Utils.HALFPI * Utils.bindRange(center.distance(myLoc) / PREF_DIST, 0.1, 1.9);
        return Utils.absAngle(center.absBearing(myLoc) + offset * orbit);
    }

    private double moveHeading(Location center, Location myLoc, double orbit) {
        return this.wallCorrectedAngle(this.distanceHeading(center, myLoc, orbit), myLoc, orbit);
    }

    public void draw(Graphics g) {
        if (this.surfWaves != null) {
            GFWave wv;
            ListIterator it = this.surfWaves.listIterator();
            while (it.hasNext()) {
                wv = (GFWave)it.next();
                wv.draw(g, this.me.getTime());
            }
            if (this.surfWaves.size() > 0) {
                wv = (GFWave)this.surfWaves.getFirst();
                g.setColor(Color.green);
                wv.draw(g, this.me.getTime());
            }
        }
        if (g != null) {
        }
    }

    private class PredictionData {
        private Location loc;
        private double velocity;
        private double heading;
        private long time;

        public PredictionData(Location loc, double velocity, double heading, long time) {
            this.loc = loc.copy();
            this.velocity = velocity;
            this.heading = heading;
            this.time = time;
        }

        public double getHeading() {
            return this.heading;
        }

        public void setHeading(double heading) {
            this.heading = heading;
        }

        public Location getLoc() {
            return this.loc;
        }

        public void setLoc(Location loc) {
            this.loc = loc;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public double getVelocity() {
            return this.velocity;
        }

        public void setVelocity(double velocity) {
            this.velocity = velocity;
        }
    }

    private class SurfPath {
        private PredictionData data;
        private double danger = 1.0;
        private Vector path;
        private Location nextLoc;
        private double diveDanger = 0.0;

        public SurfPath(double orbitDir, ScanInfo enemy, int waveDepth, double targetVelocity) {
            this.data = new PredictionData(PHWaveSurfMove.this.me.getLoc(), PHWaveSurfMove.this.me.getVelocity(), PHWaveSurfMove.this.me.getHeadingRadians(), PHWaveSurfMove.this.me.getTime());
            if (PHWaveSurfMove.this.surfWaves.size() > 0) {
                WaveBase firstWave = (WaveBase)PHWaveSurfMove.this.surfWaves.getFirst();
                this.path = new Vector(100.0 * targetVelocity, PHWaveSurfMove.this.moveHeading(firstWave.getCenter(), PHWaveSurfMove.this.me.getLoc(), orbitDir));
                ListIterator it = PHWaveSurfMove.this.surfWaves.listIterator();
                int i = 0;
                while (i < waveDepth && it.hasNext()) {
                    GFWave theWave = (GFWave)it.next();
                    PHWaveSurfMove.this.predict(this.data, theWave, orbitDir, targetVelocity);
                    int predictedGFIndex = Utils.getIndex(theWave.getOrbit() * theWave.bearingChange(this.data.getLoc()) / Utils.max_escape(theWave.getVelocity()), gfs);
                    double[] bins = PHWaveSurfMove.this.getBuffer(theWave.getSegs());
                    this.danger += bins[predictedGFIndex] / Math.pow(theWave.distanceTo(this.data.getLoc(), PHWaveSurfMove.this.me.getTime()), 1.5);
                    if (i == 0) {
                        this.nextLoc = this.data.getLoc().copy();
                    }
                    ++i;
                }
            } else {
                this.path = new Vector(100.0 * targetVelocity, PHWaveSurfMove.this.moveHeading(enemy.last().getLoc(), PHWaveSurfMove.this.me.getLoc(), orbitDir));
                this.nextLoc = PHWaveSurfMove.this.me.getLoc().project(this.path.getAngle(), targetVelocity);
            }
            this.diveDanger = this.diveDangerFactor(this.path.getAngle(), enemy.last().getBearing());
            this.danger *= this.diveDanger;
        }

        public double diveDangerFactor(double travelAngle, double angleToEnemy) {
            double relAng = Math.abs(Utils.relAngle(travelAngle - angleToEnemy)) + 1.0E-5;
            if (relAng < DIVE_ANGLE) {
                return DIVE_ANGLE / relAng;
            }
            return 1.0;
        }

        public double getDanger() {
            return this.danger;
        }

        public double getDiveDanger() {
            return this.diveDanger;
        }

        public boolean diving() {
            return this.diveDanger > 1.0;
        }

        public Vector getPath() {
            return this.path;
        }

        public PredictionData getData() {
            return this.data;
        }

        public void setDanger(double val) {
            this.danger = val;
        }
    }
}

