/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import tcf.RollingWeight;

class Prediction {
    public static final int SIZE = 101;
    private double[] m_probability = new double[101];

    Prediction() {
    }

    public void clear() {
        for (int i = 0; i < 101; ++i) {
            this.m_probability[i] = 0.0;
        }
    }

    public void copyFrom(Prediction prediction) {
        for (int i = 0; i < 101; ++i) {
            this.m_probability[i] = prediction.m_probability[i];
        }
    }

    public double maxValue() {
        double d = this.m_probability[0];
        for (int i = 1; i < 101; ++i) {
            d = Math.max(d, this.m_probability[i]);
        }
        return d;
    }

    public double totalValue() {
        double d = 0.0;
        for (int i = 0; i < 101; ++i) {
            d += this.m_probability[i];
        }
        return d;
    }

    public double get(int n) {
        return this.m_probability[n];
    }

    public double getNormalised(int n) {
        double d = this.totalValue();
        if (d > 0.0) {
            return this.m_probability[n] / d;
        }
        return 0.0;
    }

    public void set(int n, double d) {
        this.m_probability[n] = d;
    }

    public void incr(int n, double d) {
        int n2 = n;
        this.m_probability[n2] = this.m_probability[n2] + d;
    }

    public void roll(int n, double d, double d2) {
        this.m_probability[n] = RollingWeight.next(this.m_probability[n], d, d2);
    }

    public void addGf(double d, double d2) {
        int n = (int)Math.floor(d * 101.0);
        if (n < 0) {
            n = 0;
        } else if (n >= 101) {
            n = 100;
        }
        int n2 = n;
        this.m_probability[n2] = this.m_probability[n2] + d2;
    }

    public void addNotGf(double d, double d2) {
        int n = (int)Math.floor(d * 101.0);
        if (n < 0) {
            n = 0;
        } else if (n >= 101) {
            n = 100;
        }
        d2 /= 100.0;
        for (int i = 0; i < 101; ++i) {
            if (i == n) continue;
            int n2 = i;
            this.m_probability[n2] = this.m_probability[n2] + d2;
        }
    }

    public void scale(double d) {
        int n = 0;
        while (n < 101) {
            int n2 = n++;
            this.m_probability[n2] = this.m_probability[n2] * d;
        }
    }

    public void accumulate(Prediction prediction, double d) {
        for (int i = 0; i < 101; ++i) {
            int n = i;
            this.m_probability[n] = this.m_probability[n] + prediction.m_probability[i] * d;
        }
    }

    public void roll(Prediction prediction, double d) {
        for (int i = 0; i < 101; ++i) {
            this.m_probability[i] = RollingWeight.next(this.m_probability[i], d, prediction.get(i));
        }
    }

    public static double indexToGf(int n) {
        return ((double)n + 0.5) / 101.0;
    }

    public static int gfToIndex(double d) {
        int n = (int)Math.floor(d * 101.0);
        if (n < 0) {
            n = 0;
        } else if (n >= 101) {
            n = 100;
        }
        return n;
    }
}

