/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.linear.AbstractSolver;
import org.la4j.linear.LinearSystemSolver;

public class GaussianSolver
extends AbstractSolver
implements LinearSystemSolver {
    private static final long serialVersionUID = 4071505L;
    private final Matrix aa;

    public GaussianSolver(Matrix a) {
        super(a);
        this.aa = a.copyOfColumns(this.unknowns() + 1);
    }

    @Override
    public Vector solve(Vector b) {
        this.ensureRHSIsCorrect(b);
        this.aa.setColumn(this.unknowns(), b);
        this.triangularizeWithPivoting(this.aa);
        if (Math.abs(this.aa.diagonalProduct()) < Matrices.EPS) {
            this.fail("This system is singular.");
        }
        Vector x = b.blankOfLength(this.aa.columns() - 1);
        this.backSubstitution(this.aa, x);
        return x;
    }

    private void triangularizeWithPivoting(Matrix matrix) {
        int i = 0;
        while (i + 1 < matrix.rows()) {
            int maxIndex = i;
            double maxItem = Math.abs(matrix.get(i, i));
            for (int k = i + 1; k < matrix.rows(); ++k) {
                double value = Math.abs(matrix.get(k, i));
                if (!(value > maxItem)) continue;
                maxItem = value;
                maxIndex = k;
            }
            if (maxItem == 0.0) {
                throw new IllegalArgumentException("This system can't be solved.");
            }
            if (maxIndex > i) {
                matrix.swapRows(maxIndex, i);
            }
            for (int j = i + 1; j < matrix.rows(); ++j) {
                double c = matrix.get(j, i) / matrix.get(i, i);
                matrix.set(j, i, 0.0);
                for (int k = i + 1; k < matrix.columns(); ++k) {
                    matrix.updateAt(j, k, Matrices.asMinusFunction(matrix.get(i, k) * c));
                }
            }
            ++i;
        }
    }

    private void backSubstitution(Matrix matrix, Vector result) {
        for (int i = matrix.rows() - 1; i >= 0; --i) {
            double acc = 0.0;
            for (int j = i + 1; j < matrix.columns() - 1; ++j) {
                acc += result.get(j) * matrix.get(i, j);
            }
            result.set(i, (matrix.get(i, matrix.columns() - 1) - acc) / matrix.get(i, i));
        }
    }

    @Override
    public boolean applicableTo(Matrix matrix) {
        return matrix.rows() == matrix.columns();
    }
}

