/*
 * Decompiled with CFR 0.152.
 */
package xander.core.math;

import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.RCMath;
import xander.core.math.VelocityVector;
import xander.core.track.Snapshot;

public class Circular {
    private static final Log log = Logger.getLog(Circular.class);
    private static final double DEFAULT_ERROR_TOLERANCE = 0.1;
    private static final int SAMPLE_POINTS = 6;
    private static final int REFINEMENTS = 2;

    public static double[] getCenterPoint(Snapshot target_t1, Snapshot target_t0) {
        double c;
        if (target_t1 == null || target_t0 == null || target_t1.getVelocity() == 0.0) {
            return null;
        }
        if (RCMath.differenceLessThanPercent(target_t0.getHeadingRoboRadians(), target_t1.getHeadingRoboRadians(), 0.025)) {
            return null;
        }
        float velocity = (float)target_t1.getVelocity();
        double s1_ex = target_t0.getX();
        double s1_ey = target_t0.getY();
        double s2_ex = target_t1.getX();
        double s2_ey = target_t1.getY();
        VelocityVector sre1pv = new VelocityVector(target_t0.getHeadingRoboDegrees() + 90.0, velocity);
        VelocityVector sre2pv = new VelocityVector(target_t1.getHeadingRoboDegrees() + 90.0, velocity);
        Double slope1 = sre1pv.getX() == 0.0 ? null : new Double(sre1pv.getY() / sre1pv.getX());
        Double slope2 = sre2pv.getX() == 0.0 ? null : new Double(sre2pv.getY() / sre2pv.getX());
        double center_x = 0.0;
        double center_y = 0.0;
        if (slope1 == null) {
            if (slope2 == null) {
                return null;
            }
            center_x = s1_ex;
            c = s2_ey - slope2 * s2_ex;
            center_y = slope2 * center_x + c;
        } else if (slope2 == null) {
            center_x = s2_ex;
            c = s1_ey - slope1 * s1_ex;
            center_y = slope1 * center_x + c;
        } else {
            double center2_y;
            double c1 = s1_ey - slope1 * s1_ex;
            double c2 = s2_ey - slope2 * s2_ex;
            center_x = (c2 - c1) / (slope1 - slope2);
            center_y = slope1 * center_x + c1;
            if (!RCMath.differenceLessThanPercent(center_y, center2_y = slope2 * center_x + c2, 0.1)) {
                return null;
            }
        }
        double d1 = RCMath.getDistanceBetweenPoints(sre1pv.getX(), sre1pv.getY(), center_x, center_y);
        double d2 = RCMath.getDistanceBetweenPoints(sre2pv.getX(), sre2pv.getY(), center_x, center_y);
        if (!RCMath.differenceLessThanPercent(d1, d2, 0.1)) {
            return null;
        }
        return new double[]{center_x, center_y};
    }

    public static VelocityVector calculateTrajectory(Snapshot target, double initialX, double initialY, double[] centerPoint, double v_p, long time) {
        if (target.getVelocity() == 0.0) {
            double headOn = RCMath.getRobocodeAngle(initialX, initialY, target.getX(), target.getY());
            return new VelocityVector(headOn, (float)v_p);
        }
        double c_x = centerPoint[0];
        double c_y = centerPoint[1];
        double s_ex = target.getX() - initialX;
        double s_ey = target.getY() - initialY;
        double r = RCMath.getDistanceBetweenPoints(s_ex, s_ey, c_x -= initialX, c_y -= initialY);
        double myDistanceToCenter = Math.sqrt(c_x * c_x + c_y * c_y);
        double[] traj = target.getXYShift();
        double v_a = Math.abs(target.getVelocity()) / r;
        if (s_ey > c_y && traj[0] > 0.0) {
            v_a = -v_a;
        } else if (s_ey < c_y && traj[0] < 0.0) {
            v_a = -v_a;
        } else if (s_ex > c_x && traj[1] < 0.0) {
            v_a = -v_a;
        } else if (s_ex < c_x && traj[1] > 0.0) {
            v_a = -v_a;
        }
        double acos = Math.acos((s_ex - c_x) / r);
        double t_o = acos / v_a;
        if (Double.isNaN(t_o)) {
            log.error("v_a = " + v_a + "; acos = " + acos + "; r = " + r + "; s_ex = " + s_ex + "; c_x = " + c_x);
            return null;
        }
        double y1_t = r * Math.sin(v_a * t_o) + c_y;
        if (!RCMath.differenceLessThanPercent(y1_t, s_ey, 0.1)) {
            t_o = (Math.PI * 2 - acos) / v_a;
        }
        t_o += (double)(time - target.getTime());
        int index = -1;
        int nindex = -1;
        double startPoint = myDistanceToCenter - r;
        double stopPoint = myDistanceToCenter + r;
        double[] sampleDistances = new double[6];
        double[] t_fs = new double[6];
        double[] u_exs = new double[6];
        double[] u_eys = new double[6];
        double[] d_ts = new double[6];
        int refineLoop = 0;
        while (refineLoop < 2) {
            if (index >= 0) {
                startPoint = Math.min(sampleDistances[index], sampleDistances[nindex]);
                stopPoint = Math.max(sampleDistances[index], sampleDistances[nindex]);
            }
            double increment = (stopPoint - startPoint) / 5.0;
            int i = 0;
            while (i < 6) {
                sampleDistances[i] = startPoint + increment * (double)i;
                ++i;
            }
            double[] t_cs = new double[6];
            int i2 = 0;
            while (i2 < 6) {
                t_cs[i2] = sampleDistances[i2] / v_p;
                ++i2;
            }
            i2 = 0;
            while (i2 < 6) {
                t_fs[i2] = t_o + t_cs[i2];
                u_exs[i2] = r * Math.cos(v_a * t_fs[i2]) + c_x;
                u_eys[i2] = r * Math.sin(v_a * t_fs[i2]) + c_y;
                ++i2;
            }
            i2 = 0;
            while (i2 < 6) {
                d_ts[i2] = Math.abs(sampleDistances[i2] - RCMath.getDistanceBetweenPoints(0.0, 0.0, u_exs[i2], u_eys[i2]));
                ++i2;
            }
            double closest = Double.POSITIVE_INFINITY;
            double nextClosest = Double.POSITIVE_INFINITY;
            int i3 = 0;
            while (i3 < 6) {
                if (d_ts[i3] < closest) {
                    nindex = index;
                    nextClosest = closest;
                    index = i3;
                    closest = d_ts[i3];
                } else if (d_ts[i3] < nextClosest) {
                    nindex = i3;
                    nextClosest = d_ts[i3];
                }
                ++i3;
            }
            ++refineLoop;
        }
        if (index == -1) {
            log.warn("No closest sample point found.  Circular trajectory cannot be calculated.");
            log.warn("t_o = " + Logger.format(t_o));
            return null;
        }
        double v_fh = Math.sqrt(u_exs[index] * u_exs[index] + u_eys[index] * u_eys[index]);
        double v_x = u_exs[index] * v_p / v_fh;
        double v_y = u_eys[index] * v_p / v_fh;
        return new VelocityVector(v_x, v_y, 0.0);
    }
}

