/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.bullet;

import dmh.robocode.data.BattleConstants;
import dmh.robocode.data.Location;
import dmh.robocode.enemy.EnemyRobot;
import dmh.robocode.utils.Geometry;

public class SimulatedBullet {
    private BulletResult result = BulletResult.IN_PROGRESS;
    private EnemyRobot enemy;
    private Location firedFrom;
    private long startTime;
    private double bearing;
    private double velocity;
    private double robotRadius;

    public SimulatedBullet(EnemyRobot enemy, Location firedFrom, long startTime, double bearing, double velocity) {
        this.enemy = enemy;
        this.firedFrom = firedFrom;
        this.startTime = startTime;
        this.bearing = bearing;
        this.velocity = velocity;
        this.robotRadius = Math.min(BattleConstants.getInstance().getRobotHeight(), BattleConstants.getInstance().getRobotWidth()) / 2.0;
    }

    public BulletResult getResult() {
        return this.result;
    }

    public Location getFiredFrom() {
        return this.firedFrom;
    }

    public EnemyRobot getEnemy() {
        return this.enemy;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getBearing() {
        return this.bearing;
    }

    protected void changeBearing(double newBearing) {
        this.bearing = newBearing;
    }

    public void processAtTime(long time) {
        double enemyLocationTolerance;
        if (this.result == BulletResult.IN_PROGRESS && (enemyLocationTolerance = (double)Math.abs(time - this.enemy.getLatestRadarObservation().getTimeSeen()) * 8.0) <= this.robotRadius) {
            Location myLocation = Geometry.getLocationAtBearing(this.firedFrom, this.bearing, (double)(time - this.startTime) * this.velocity);
            double distanceToEnemy = Geometry.getDistanceBetweenLocations(myLocation, this.enemy.getLatestRadarObservation().getLocation());
            if (!this.enemy.isAlive()) {
                this.result = BulletResult.DEAD;
            } else if (this.isLocationOutOfBattle(myLocation)) {
                this.result = BulletResult.MISS;
            } else if (distanceToEnemy <= this.robotRadius - enemyLocationTolerance) {
                this.result = BulletResult.HIT;
            }
        }
    }

    private boolean isLocationOutOfBattle(Location myLocation) {
        return myLocation.getX() < 0.0 || myLocation.getY() < 0.0 || myLocation.getX() > BattleConstants.getInstance().getBattlefieldWidth() || myLocation.getY() > BattleConstants.getInstance().getBattlefieldHeight();
    }

    public static enum BulletResult {
        IN_PROGRESS,
        HIT,
        MISS,
        DEAD;

    }
}

