/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries;

import florent.XSeries.Configuration;
import florent.XSeries.gun.GunFactory;
import florent.XSeries.gun.GunStrategy;
import florent.XSeries.gun.GunType;
import florent.XSeries.movement.MovementFactory;
import florent.XSeries.movement.MovementStrategy;
import florent.XSeries.movement.MovementType;
import florent.XSeries.radar.BotType;
import florent.XSeries.radar.RadarFactory;
import florent.XSeries.radar.RadarStrategy;
import florent.XSeries.radar.Tracker;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import florent.XSeries.utils.StopWatch;
import florent.stats.StatKeeper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Arrays;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class X2
extends Xmen {
    public static AdvancedRobot instance;
    private static MovementFactory movementFactory;
    private static GunFactory gunFactory;
    private static RadarFactory radarFactory;
    private static StatKeeper stats;
    private MovementStrategy movement;
    public GunStrategy gun;
    private RadarStrategy radar;
    private Tracker tracker;
    private static boolean[] finished;
    private static double computationTime;
    private static double radarTime;
    private static double gunTime;
    private static double movementTime;
    private static double trackerTime;
    private static final boolean FATALITY = false;

    static {
        movementFactory = MovementFactory.getInstance();
        gunFactory = GunFactory.getInstance();
        radarFactory = RadarFactory.getInstance();
    }

    public void onDeath(DeathEvent e) {
        this.radar.onDeath(e);
        this.tracker.onDeath(e);
        this.gun.onDeath(e);
        this.movement.onDeath(e);
        stats.onDeath(e);
        this.endRound();
    }

    public void onPaint(Graphics2D e) {
        if (Configuration.SG) {
            if (this.radar != null) {
                this.radar.onPaint(e);
            }
            if (this.tracker != null) {
                this.tracker.onPaint(e);
            }
            if (this.gun != null) {
                this.gun.onPaint(e);
            }
            if (this.movement != null) {
                this.movement.onPaint(e);
            }
            if (stats != null) {
                stats.onPaint(e);
            }
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        this.radar.onSkippedTurn(e);
        this.tracker.onSkippedTurn(e);
        this.gun.onSkippedTurn(e);
        this.movement.onSkippedTurn(e);
        stats.onSkippedTurn(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        if (Configuration.team) {
            super.onBulletHit(e);
        }
        this.radar.onBulletHit(e);
        this.tracker.onBulletHit(e);
        this.gun.onBulletHit(e);
        this.movement.onBulletHit(e);
        stats.onBulletHit(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (Configuration.team) {
            super.onBulletHitBullet(e);
        }
        this.radar.onBulletHitBullet(e);
        this.tracker.onBulletHitBullet(e);
        this.gun.onBulletHitBullet(e);
        this.movement.onBulletHitBullet(e);
        stats.onBulletHitBullet(e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        if (Configuration.team) {
            super.onBulletMissed(e);
        }
        this.radar.onBulletMissed(e);
        this.tracker.onBulletMissed(e);
        this.gun.onBulletMissed(e);
        this.movement.onBulletMissed(e);
        stats.onBulletMissed(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.radar.onHitByBullet(e);
        this.tracker.onHitByBullet(e);
        this.gun.onHitByBullet(e);
        this.movement.onHitByBullet(e);
        stats.onHitByBullet(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.radar.onHitRobot(e);
        this.tracker.onHitRobot(e);
        this.gun.onHitRobot(e);
        this.movement.onHitRobot(e);
        stats.onHitRobot(e);
    }

    public void onHitWall(HitWallEvent e) {
        this.radar.onHitWall(e);
        this.tracker.onHitWall(e);
        this.gun.onHitWall(e);
        this.movement.onHitWall(e);
        stats.onHitWall(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Configuration.update();
        if (this.getOthers() < 2) {
            this.radar = radarFactory.getStrategy("DUEL");
        }
        this.radar.onRobotDeath(e);
        this.tracker.onRobotDeath(e);
        this.gun.onRobotDeath(e);
        this.movement.onRobotDeath(e);
        stats.onRobotDeath(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (Configuration.team) {
            super.onScannedRobot(e);
        }
        if (this.rejectScan) {
            return;
        }
        this.radar.onScannedRobot(e);
        this.tracker.onScannedRobot(e);
        this.movement.onScannedRobot(e);
        this.gun.onScannedRobot(e);
        stats.onScannedRobot(e);
    }

    public void onWin(WinEvent e) {
        this.radar.onWin(e);
        this.tracker.onWin(e);
        this.gun.onWin(e);
        this.movement.onWin(e);
        stats.onWin(e);
        this.endRound();
    }

    public void run() {
        System.gc();
        if (finished == null) {
            finished = new boolean[this.getNumRounds()];
            Arrays.fill(finished, false);
        }
        this.type = this.getEnergy() > 100.0 ? (this.getEnergy() > 120.0 ? BotType.LEADER : BotType.DROID) : BotType.REGULAR;
        instance = this;
        Configuration.initClass(this);
        stats = StatKeeper.getInstance();
        movementFactory.setMe(this);
        gunFactory.setMe(this);
        radarFactory.setMe(this);
        stats.setMe((AdvancedRobot)this);
        Tracker.setMe(this);
        this.tracker = Tracker.getInstance();
        this.setColors(Color.BLACK, Color.RED, Color.BLACK);
        this.movement = movementFactory.getStrategy(MovementType.BLACKBOARDMOVEMENT);
        if (this.getOthers() > 1) {
            this.radar = radarFactory.getStrategy("MELEE");
            this.gun = gunFactory.getStrategy(GunType.PATTERNMATCHINGGUN);
        } else {
            this.radar = radarFactory.getStrategy("DUEL");
            this.gun = gunFactory.getStrategy(GunType.PATTERNMATCHINGGUN);
        }
        if (this.getEnergy() == 200.0) {
            Configuration.SG = true;
        }
        this.initRound();
        this.radar.initRound();
        this.tracker.initRound();
        this.gun.initRound();
        this.movement.initRound();
        stats.initRound();
        movementFactory.getStrategy(MovementType.FATALITYMOVEMENT).initRound();
        gunFactory.getStrategy(GunType.FATALITYGUN).initRound();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        StopWatch stopWatch = new StopWatch();
        while (true) {
            this.gun.holdFire = false;
            Configuration.synch();
            if (Configuration.team) {
                super.onMainLoop();
            }
            stopWatch.reset();
            stopWatch.start();
            this.radar.onMainLoop();
            stopWatch.intermediate();
            double t = stopWatch.getElapsedTime() / 100000L;
            computationTime += t;
            radarTime += t;
            stopWatch.reset();
            stopWatch.start();
            this.tracker.onMainLoop();
            stopWatch.intermediate();
            t = stopWatch.getElapsedTime() / 100000L;
            computationTime += t;
            trackerTime += t;
            stopWatch.reset();
            stopWatch.start();
            this.movement.onMainLoop();
            stopWatch.intermediate();
            t = stopWatch.getElapsedTime() / 100000L;
            computationTime += t;
            movementTime += t;
            stopWatch.reset();
            stopWatch.start();
            this.gun.onMainLoop();
            stopWatch.intermediate();
            t = stopWatch.getElapsedTime() / 100000L;
            computationTime += t;
            gunTime += t;
            stats.onMainLoop();
            this.execute();
        }
    }

    public void endRound() {
        if (finished[this.getRoundNum()]) {
            return;
        }
        X2.finished[this.getRoundNum()] = true;
        this.movement = movementFactory.getStrategy(MovementType.BLACKBOARDMOVEMENT);
        this.gun = gunFactory.getStrategy(GunType.PATTERNMATCHINGGUN);
        this.tracker.endRound();
        this.gun.endRound();
        this.movement.endRound();
        this.radar.endRound();
        stats.endRound();
        RobocodeTools.log("radar " + radarTime / computationTime * 100.0);
        RobocodeTools.log("tracker " + trackerTime / computationTime * 100.0);
        RobocodeTools.log("movement " + movementTime / computationTime * 100.0);
        RobocodeTools.log("gun " + gunTime / computationTime * 100.0);
        RobocodeTools.log("total " + (gunTime + radarTime + trackerTime + movementTime) / computationTime * 100.0 + "|" + (gunTime + radarTime + trackerTime + movementTime) + "=" + computationTime);
    }
}

