/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.radar;

import florent.XSeries.radar.DuelRadar;
import florent.XSeries.radar.MeleeRadar;
import florent.XSeries.radar.RadarStrategy;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import java.util.HashMap;
import robocode.AdvancedRobot;

public class RadarFactory {
    public static final String DUEL = "DUEL";
    public static final String MELEE = "MELEE";
    private HashMap<String, RadarStrategy> strategies = new HashMap();
    private Xmen me;
    private static RadarFactory instance;

    private RadarFactory() {
    }

    public static RadarFactory getInstance() {
        if (instance == null) {
            instance = new RadarFactory();
        }
        return instance;
    }

    public RadarStrategy getStrategy(String key) {
        if (this.strategies.containsKey(key)) {
            return this.strategies.get(key);
        }
        if (key.equals(DUEL)) {
            DuelRadar strategy = new DuelRadar((AdvancedRobot)this.me);
            this.strategies.put(key, strategy);
            return strategy;
        }
        if (key.equals(MELEE)) {
            MeleeRadar strategy = new MeleeRadar(this.me);
            this.strategies.put(key, strategy);
            return strategy;
        }
        RobocodeTools.log("Unknown key " + this.getClass().getName());
        return null;
    }

    public void setMe(Xmen me) {
        this.me = me;
    }
}

