/*
 * Decompiled with CFR 0.152.
 */
package agd.predict;

import agd.predict.Footprint;
import agd.predict.TargetPrediction;
import agd.util.Coord;
import java.util.List;
import java.util.ListIterator;

class AveragePositionPrediction
extends TargetPrediction {
    private int period = 0;

    public AveragePositionPrediction() {
        this(0);
    }

    public AveragePositionPrediction(int period) {
        this.period = period;
    }

    public Coord predictTarget(List recentFootprints, long time) {
        Coord avPos = null;
        if (recentFootprints.size() > 0) {
            ListIterator lit = recentFootprints.listIterator(recentFootprints.size());
            Footprint mostRecentfp = (Footprint)recentFootprints.get(recentFootprints.size() - 1);
            long earliestTime = 0L;
            if (this.period > 0) {
                earliestTime = mostRecentfp.getTime() - (long)this.period;
            }
            long footprints = 0L;
            double totalx = 0.0;
            double totaly = 0.0;
            Footprint fp = null;
            while (lit.hasPrevious()) {
                fp = (Footprint)lit.previous();
                if (fp.getTime() < earliestTime) break;
                totalx += fp.getPosition().getX();
                totaly += fp.getPosition().getY();
                ++footprints;
            }
            avPos = new Coord(totalx / (double)footprints, totaly / (double)footprints);
        }
        return avPos;
    }

    public String toString() {
        return "Av pos(" + this.period + ")";
    }
}

