/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.intel.ChessBoard;
import agd.util.AdvancedRobotAdapter;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.CoordInt;
import agd.util.Enemy;
import agd.util.FastGoto;
import agd.util.GotoMethod;
import agd.util.Navigation;
import agd.util.NavigationStrategy;
import agd.util.Region;
import agd.util.RobotInformation;
import agd.util.World;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;

public class ChessStrategy
extends AdvancedRobotAdapter
implements NavigationStrategy {
    AdvancedRobot ar = World.getAdvancedRobot();
    ChessBoard board;
    NavigationStrategy gotoStrategy = null;
    RobotInformation ri;
    CoordInt currentSquare;
    List recentlyVisitedSquares;
    int recentlyVisitedMemoryLimit;
    long timeLastHitRobot = 0L;
    HitRobotEvent lastHitRobotEvent = null;
    GotoMethod robotBackoff = null;
    public static final int PROXIMITY_MULTIPLIER = 6000;
    public static final int DESIRED_LOCATION_MULTIPLIER = 500;
    public static final int RECENT_OCCUPATION_MULTIPLIER = 100;
    public static final int BULLET_THREAT_MULTIPLIER = 3;
    Map enemydata = new HashMap();
    Region[] regions;
    static final int TIME_TO_MOVE = 200;

    public ChessStrategy(RobotInformation ri) {
        this(ri, 0);
    }

    public ChessStrategy(RobotInformation ri, int max) {
        this.board = ChessBoard.getInstance();
        this.ri = ri;
        this.regions = Region.getEdgeRegions(World.getBattleFieldSize().getX(), World.getBattleFieldSize().getY(), (int)((double)this.board.getSquareSize() * 2.5));
        this.recentlyVisitedSquares = new LinkedList();
        this.recentlyVisitedMemoryLimit = 6;
    }

    public void discard() {
        this.ri.removeListener(this);
    }

    public boolean isDone() {
        return false;
    }

    public Coord calcDesiredPoint_Quietest() {
        Region quietestRegion = Region.getPreferredRegion(this.regions, this.ri.getEnemies().values());
        Region currentRegion = Region.whichRegionContains(this.regions, this.ri.getPosition());
        Coord desiredPoint = null;
        desiredPoint = currentRegion == null || quietestRegion.getCount() < currentRegion.getCount() ? quietestRegion.getHideout() : currentRegion.getHideout();
        return desiredPoint;
    }

    public Coord calcDesiredPoint() {
        Region currentRegion = Region.whichRegionContains(this.regions, this.ri.getPosition());
        if (currentRegion != null) {
            return currentRegion.getHideout();
        }
        return this.calcDesiredPoint_Quietest();
    }

    Vector getCandidateDestinationSquares(CoordInt currentPos) {
        Vector candidates = this.board.getNeighbours(currentPos);
        candidates.add(this.board.getSquare(currentPos));
        return candidates;
    }

    public Navigation navigate() {
        Navigation movement = null;
        this.board = ChessBoard.getInstance();
        CoordInt currentPos = this.board.toCoordInt(World.getPosition());
        this.maintainRecentlyVisitedList(currentPos);
        if (World.getTime() - this.timeLastHitRobot < 25L && this.robotBackoff != null && !this.robotBackoff.isDone()) {
            movement = this.robotBackoff.navigate();
        } else if (this.gotoStrategy == null || this.gotoStrategy.isDone()) {
            Coord desiredLocation = this.calcDesiredPoint();
            if (World.isDebug()) {
                System.out.println("Desired location is " + desiredLocation);
            }
            Vector possibleDestinations = this.getCandidateDestinationSquares(currentPos);
            Collections.sort(possibleDestinations, new PreferredSquareComparator(desiredLocation, this.board));
            ChessBoard.ChessSquare destination = (ChessBoard.ChessSquare)possibleDestinations.get(0);
            if (World.isDebug()) {
                String trailer = "Moving to square " + destination.getIntPosition();
                this.board.writeSurroundingCells(currentPos, 2, trailer);
            }
            this.gotoStrategy = new FastGoto(this.ri, this.board.toCoord(destination.getIntPosition()));
            movement = this.gotoStrategy.navigate();
        } else {
            movement = this.gotoStrategy.navigate();
        }
        return movement;
    }

    public void onHitRobot(HitRobotEvent hre) {
        this.timeLastHitRobot = World.getTime();
        this.lastHitRobotEvent = hre;
        Coord currentPos = this.ri.getPosition();
        double ourHeading = this.ri.getAdvancedRobot().getHeading();
        Compass reverseHeading = new Compass(ourHeading + hre.getBearing() + 180.0);
        Coord gotoPos = currentPos.applyVector(reverseHeading, 50.0);
        this.robotBackoff = new FastGoto(this.ri, gotoPos);
    }

    void maintainRecentlyVisitedList(CoordInt currentPos) {
        ChessBoard.ChessSquare curSq = this.board.getSquare(currentPos);
        int curSqIdx = this.recentlyVisitedSquares.indexOf(curSq);
        if (curSqIdx == -1) {
            this.recentlyVisitedSquares.add(curSq);
            if (this.recentlyVisitedSquares.size() > this.recentlyVisitedMemoryLimit) {
                this.recentlyVisitedSquares.remove(0);
            }
        } else if (curSqIdx != this.recentlyVisitedSquares.size() - 1) {
            this.recentlyVisitedSquares.remove(curSqIdx);
            this.recentlyVisitedSquares.add(curSq);
        }
    }

    public static Coord calcEnemyRepulsion(Collection enemies, Coord point) {
        double xforce = 0.0;
        double yforce = 0.0;
        double enemyGravity = 1000.0;
        Enemy e = null;
        Iterator i = enemies.iterator();
        while (i.hasNext()) {
            e = (Enemy)i.next();
            Coord ePos = e.getLastSighting().getPosition();
            double distance = point.distanceTo(ePos);
            double force = enemyGravity / Math.pow(distance, 2.0);
            Compass forcedir = ePos.headingTo(point);
            xforce += Math.sin(forcedir.getRadians()) * force;
            yforce += Math.cos(forcedir.getRadians()) * force;
        }
        return new Coord(xforce, yforce);
    }

    public static double distanceToClosest(Collection points) {
        Iterator i = points.iterator();
        return 0.0;
    }

    static {
        PROXIMITY_MULTIPLIER = 6000;
        DESIRED_LOCATION_MULTIPLIER = 500;
        RECENT_OCCUPATION_MULTIPLIER = 100;
        BULLET_THREAT_MULTIPLIER = 3;
        TIME_TO_MOVE = 200;
    }

    class PreferredSquareComparator
    implements Comparator {
        public Coord desiredDestination;

        public PreferredSquareComparator(Coord p, ChessBoard board) {
            this.desiredDestination = p;
        }

        public int compare(Object o1, Object o2) {
            double overallFactor2;
            ChessBoard.ChessSquare sq1 = (ChessBoard.ChessSquare)o1;
            ChessBoard.ChessSquare sq2 = (ChessBoard.ChessSquare)o2;
            double distance1 = ChessStrategy.this.board.toCoord(sq1.getIntPosition()).distanceTo(this.desiredDestination);
            double distance2 = ChessStrategy.this.board.toCoord(sq2.getIntPosition()).distanceTo(this.desiredDestination);
            double desireFactor1 = distance1 / Math.max(distance1, distance2);
            double desireFactor2 = distance2 / Math.max(distance1, distance2);
            int recentOccupationPenalty1 = 100 * (ChessStrategy.this.recentlyVisitedSquares.indexOf(sq1) + 1);
            int recentOccupationPenalty2 = 100 * (ChessStrategy.this.recentlyVisitedSquares.indexOf(sq2) + 1);
            double overallFactor1 = sq1.getThreatFactor() + (desireFactor1 *= 500.0) + (double)recentOccupationPenalty1;
            return overallFactor1 - (overallFactor2 = sq2.getThreatFactor() + (desireFactor2 *= 500.0) + (double)recentOccupationPenalty2) < 0.0 ? -1 : 1;
        }
    }
}

