package dft.inject.gun;
import dft.inject.util.*;
import robocode.*;
import java.awt.geom.*;
import java.awt.Color;

public class Cannon {
	
	private double absBearing, enemyDistance, enemyVelocity;
	private double lastEnemyVelocity, lastEnemyLatVelocity;
	private double lastVelocityChangeTime;
	private double enemyLatVelocity, enemyAdvVelocity;
	private double binaryDirection = 1;
	private double enemyDirection = binaryDirection*Math.asin(8D/11D);	
	private Point2D myLocation, enemyLocation;
	private Rectangle2D battleField;
	
	private double wallDistance, reverseWallDistance;	
	
	private double finalBulletPower, finalGunTurn;	
	private static final int MIDDLE_FACTOR = 16;
	private static final int TOTAL_FACTORS = 33;
	
	private static double[][][][][][][] aFactors = new double[3][5][5][5][10][3][TOTAL_FACTORS];
	private static double[][][][][][][] bFactors = new double[3][5][5][5][8][3][TOTAL_FACTORS];
		
	GunWave root, current;
	
	public double getGunTurn() {
		return finalGunTurn;
	}
	
	public double getBulletPower() {
		return finalBulletPower;
	}
	
	public void onScannedRobot(AdvancedRobot a, ScannedRobotEvent e) {
		
		// Determine bullet power
		// finalBulletPower = 3.0;
		// TARGETTING CHALLENGE
		//finalBulletPower = 3.0; 
		
		finalBulletPower = 1.9;
		if (e.getDistance() < 240) finalBulletPower = 3.0;
		finalBulletPower = Math.min(finalBulletPower,e.getEnergy()/4);
		finalBulletPower = Math.min(finalBulletPower,a.getEnergy()/2);
		
		double bulletSpeed = 20 - 3 * finalBulletPower;
		
		lastEnemyLatVelocity = enemyLatVelocity;
		lastEnemyVelocity = enemyVelocity;
		enemyVelocity = e.getVelocity();		
		
		absBearing = e.getBearingRadians() + a.getHeadingRadians();
		myLocation = new Point2D.Double(a.getX(),a.getY());		
		enemyLocation = Utils.project(myLocation,absBearing,(enemyDistance=e.getDistance()));						
		battleField = new Rectangle2D.Double(18, 18, a.getBattleFieldWidth() - 36, a.getBattleFieldHeight() - 36);
		
		// Determine the enemy's lateral velocity and enemy direction (escape envelope)
		enemyLatVelocity = enemyVelocity*Math.sin(e.getHeadingRadians() - absBearing);
		if (enemyLatVelocity != 0)
			binaryDirection = (enemyLatVelocity > 0 ? 1 : -1); 
		enemyDirection = binaryDirection * Math.asin(8/bulletSpeed);	
		
		// Returns the enemy's lateral distance to wall as a value between 0 and 1
		wallDistance = 1.1;
		while (wallDistance >= 0.1 && !battleField.contains(
				Utils.project(myLocation, 
						absBearing + (wallDistance-=0.1)*enemyDirection, 
						enemyDistance)));
		
		// Returns the enemy's reverse lateral distance to wall
		reverseWallDistance = 1.1;
		while (reverseWallDistance >= 0.1 && !battleField.contains(
				Utils.project(myLocation, 
						absBearing - (reverseWallDistance-=0.1)*enemyDirection, 
						enemyDistance)));
		
		// Timer, or velocity change							
		double moveTime = bulletSpeed*lastVelocityChangeTime++/enemyDistance;
				
		int bestIndex = MIDDLE_FACTOR;
		if (e.getEnergy() > 0 && a.getEnergy() > 0) {
			
			// Segments
			int distanceIndex = (int)enemyDistance / 240;		
			int fastDistanceIndex = (int)enemyDistance / 360;
			
			int wallIndex = (int)(wallDistance * 3);
			int fastWallIndex = (int)(wallDistance * 1.5);
			
			int reverseWallIndex = (int)(reverseWallDistance * 2);
			int fastReverseWallIndex = (int)(reverseWallDistance * 1.25);
			
			int velIndex = (int)Math.abs(enemyLatVelocity/2);		
			int fastVelIndex = (int)Math.abs(enemyLatVelocity/2.67);
			
			int timerIndex = moveTime < .4 ? 1 : moveTime < .8 ? 2 : moveTime < 1.2 ? 3 : 4;		
			int fastTimerIndex = moveTime < .6 ? 1 : 2;	
			
			int accelIndex = (int)Math.round(Math.abs(enemyVelocity) - Math.abs(lastEnemyVelocity));
			
			if (accelIndex != 0)
				accelIndex = accelIndex > 0 ? 2 : 1;
			
			if (accelIndex > 0) {
				lastVelocityChangeTime = 0;
				timerIndex = fastTimerIndex = 0;
				//accelIndex = (int)Math.round(Math.abs(enemyVelocity) - Math.abs(lastEnemyVelocity));				
				//velIndex = (int)Math.abs(enemyVelocity/2.67);
				//fastVelIndex = (int)Math.abs(enemyVelocity/4.01);
			}
				
			GunWave g = new GunWave();
			
			g.bulletOrigin = myLocation;
			g.targetOrigin = g.currentTarget = Utils.project(enemyLocation,e.getHeadingRadians(),-enemyVelocity);
			g.bulletAngle = Utils.absoluteBearing(g.bulletOrigin,g.targetOrigin);
			g.bulletVelocity = bulletSpeed;
			g.fireTime = g.lastTime = a.getTime()-1;
			g.escapeEnvelope = enemyDirection;
			
			g.aSeg = aFactors[accelIndex][velIndex][timerIndex][wallIndex][distanceIndex][reverseWallIndex];
			g.bSeg = bFactors[accelIndex][fastVelIndex][fastTimerIndex][fastWallIndex][fastDistanceIndex][fastReverseWallIndex];
			
			if (a.getGunHeat() == 0) g.real = true;
			
			// This adds the wave appropriately to the list
			if (root == null)		
				root = current = g;
			else
				current = (current.next = g);			
						
			while (root != null && root.update(a.getTime(),enemyLocation)) {
				root = root.next;			
			}
			if (root != null) {
				GunWave waveIterator = root.next;
				while (waveIterator != null) {					
					waveIterator.update(a.getTime(),enemyLocation);
					waveIterator = waveIterator.next;
				}
			}
			// Search for the best index			
			double bestA = Utils.smoothed(bestIndex,g.aSeg,TOTAL_FACTORS); 
			double bestB = Utils.smoothed(bestIndex,g.bSeg,TOTAL_FACTORS);
			for (int i = MIDDLE_FACTOR*2-1; i >= 1; i--) {	
				double aCur = Utils.smoothed(i,g.aSeg,TOTAL_FACTORS);
				double bCur = Utils.smoothed(i,g.bSeg,TOTAL_FACTORS);
				if (aCur + bCur > bestA + bestB) {
				//if (battleField.contains(Utils.project(myLocation,robocode.util.Utils.normalRelativeAngle(absBearing+enemyDirection*(i/(double)MIDDLE_FACTOR-1)),enemyDistance)));
						bestIndex = i;
						bestA = aCur;
						bestB = bCur;
				}
				//if (g.aSeg[i]+g.bSeg[i]> g.aSeg[bestIndex]+g.bSeg[bestIndex])
				//	bestIndex = i;
			}
			
		}
		if (a.getGunHeat() < a.getGunCoolingRate()*3)
			finalGunTurn = robocode.util.Utils.normalRelativeAngle(absBearing-a.getGunHeadingRadians()+enemyDirection*(bestIndex/(double)MIDDLE_FACTOR-1));
		else
			finalGunTurn = robocode.util.Utils.normalRelativeAngle(absBearing-a.getGunHeadingRadians());
		
	}
	
		
	class GunWave {
		GunWave next;				
		Point2D bulletOrigin, targetOrigin;
		Point2D currentTarget;
		double bulletAngle, bulletVelocity, escapeEnvelope;
		long fireTime, lastTime;
		
		double[] aSeg, bSeg;
				
		boolean real = false;
		
		
		
		boolean update(long time, Point2D enemy) {
			long dTime;
			double dX = (enemy.getX()-currentTarget.getX())/(dTime = time-lastTime);
			double dY = (enemy.getY()-currentTarget.getY())/dTime;
			do	{
				if (bulletOrigin.distance(currentTarget) <= bulletVelocity*(lastTime-fireTime)) {
					
					int index = (int)Utils.findGF(bulletAngle,Utils.absoluteBearing(bulletOrigin,currentTarget),escapeEnvelope,MIDDLE_FACTOR);
					index = (int)Utils.minMax(1,MIDDLE_FACTOR*2-1,index);
					
					double weightReal = 1;
					if (real) weightReal = 5;
					
					// This rolls the previously saved data (necessary to keep it as a percentage)
					for (int i = 1; i < MIDDLE_FACTOR*2; i++) {
						aSeg[i]*=aSeg[0]/(aSeg[0]+weightReal);
						bSeg[i]*=bSeg[0]/(bSeg[0]+weightReal);						
					}	
					// Update the appropriate buckets, [0] is the total number of hits in that aSeg
					aSeg[0]+=weightReal;					
					aSeg[index]+=(weightReal/aSeg[0]);
					/*aSeg[index+1]+=(.05/aSeg[0]);
					aSeg[index-1]+=(.05/aSeg[0]);*/
					bSeg[0]+=weightReal;
					bSeg[index]+=(weightReal/bSeg[0]);
					/*bSeg[index+1]+=(.05/bSeg[0]);	
					bSeg[index-1]+=(.05/bSeg[0]);*/
					
					return true;
				}
				lastTime++;
				currentTarget.setLocation(currentTarget.getX()+dX, currentTarget.getY()+dY);
				
			}
			while (lastTime < time);
			return false;
		}
	}	
}
