package ags.rougedc.movement;

import static robocode.util.Utils.normalAbsoluteAngle;
import static robocode.util.Utils.normalRelativeAngle;

import java.util.List;
import ags.rougedc.base.Rules;
import ags.utils.points.*;
import ags.rougedc.robots.*;
import ags.rougedc.waves.EnemyWave;

/**
 * @author Alexander Schultz
 */
public class DistanceDriver implements RobotDriver {
    final private Rules rules;
    final private EnemyList enemies;
    final private double goaldistance;
    
    private double acceleration;
    private double turn;
    
    public DistanceDriver(Rules rules, EnemyList enemies, double goaldistance) {
        this.rules = rules;
        this.enemies = enemies;
        this.goaldistance = goaldistance;
    }
    
    public void run(VirtualRobot bot, List<EnemyWave> waves) {
        WallSmoother smoother = new WallSmoother(rules);
        
        EnemyRobot target = enemies.getTarget();
        if (target == null) {
            turn = 0;
            acceleration = -bot.getVelocity().magnitude;
            return;
        }
        
        RelativePoint origin = target.getRelativeLocation();
        
        // Add a distancing factor!
        double distancing_direction=1.0;
        if (origin.magnitude > goaldistance)
            distancing_direction = 0;
        else
            distancing_direction = Math.PI;
        
        //System.out.println("Distancing factor: "+distancing_factor);
        
        double direction = normalAbsoluteAngle(origin.direction+distancing_direction);
        
        direction = smoother.smoothAngle2(bot.getLocation(), direction, bot.getVelocity());
        
        turn = normalRelativeAngle(direction - bot.getVelocity().direction);
        
        // Back as front
        if (Math.abs(turn) > Math.PI/2) {
            turn = normalRelativeAngle(turn + Math.PI);
            acceleration = Double.NEGATIVE_INFINITY;
        } else {
            acceleration = Double.POSITIVE_INFINITY;
        }
    }
    
    public double getAcceleration() {
        return acceleration;
    }

    public double getAngularVelocity() {
        return turn;
    }
}
