package kvk.Movement;
import kvk.Bots.Bot;
import kvk.ExtendedRobot;
import kvk.Utils.BattleField;
import kvk.Utils.C;
import kvk.Utils.Fct;
import kvk.Utils.Manager;
import kvk.Utils.Point;
import robocode.*;

/**
 *  Mouvement en spirale vers le centre de l'arne
 *
 * @author     Ssin.le.Terrible
 * @created    17 fvrier 2004
 */
public class MoveToCenter extends Manager {
	//{{{*** Variables
	private  double  lateralAngle    = 0.2d;
	private  double  distanceFactor  = 0.9d;
	private  double  minDistance     = 50d;
	private  double  maxDistance     = BattleField.getDiagonale() / 2d - 100d;

	public MoveToCenter(ExtendedRobot er) {
		super(er);
	}

	public void action() {
		Point   myPosition    = myBot.getCoord();
		Point   cCoord        = new Point(BattleField.getCentreX(), BattleField.getCentreY());
		double  distance      = cCoord.distance(myPosition);
		double  moveAngle;
		double  turnAngle;
		double  tries         = 0d;
		Point   nextPosition  = null;

		if (distanceFactor < 1d && distance < minDistance) {
			distanceFactor = 1.1d;
		}
		else if (distanceFactor > 1d && distance > maxDistance) {
			distanceFactor = 0.9d;
		}

		//Calcul de la destination
		do {
			nextPosition = Fct.calcXY(cCoord, Fct.bearing(cCoord, myPosition) + lateralAngle, distance * (distanceFactor - tries / 100d));
			tries++;
		} while (tries < 100 && !nextPosition.isOnSmallRoundedField());

		//Mouvement
		moveAngle = robocode.util.Utils.normalRelativeAngle(Fct.bearing(myPosition, nextPosition) - myBot.getHeadingRadians());
		turnAngle = Math.atan(Math.tan(moveAngle));
		myBot.setTurnRightRadians(turnAngle);
		myBot.setAhead(myPosition.distance(nextPosition) * (moveAngle == turnAngle ? 1 : -1));
		myBot.setMaxVelocity(8d);
	}

	public void reinitialise() {
	}
}

