/*
 * SegmentationManager.java
 *
 * Created on 15 maart 2004, 0:54
 */

package vic;
/**
 *
 * @author  vic
 */
public class SegmentationManager extends Log
{
    int SegmentSize = 19;
    int startIndex, endIndex;
    double Dmin, Dmax;

    double aim(double Power, Situation situation, double enemyX, double enemyY, double currentHeading, double meX, double meY)
    {
        if(log.size() == 0)                                     //if the Log is empty, revert to head on targeting
        {
            return Math.atan2(enemyX-meX, enemyY-meY);
        }
        else
        {
            getSegmentBorders(situation);                               //first define the Segmentation borders
            return PerformStatistics(situation.getDimension(0), Power, enemyX, enemyY, currentHeading, meX, meY, situation);
        }
    }

    double PerformStatistics(byte ETA, double Power, double enemyX, double enemyY, double currentHeading, double meX, double meY, Situation situation)
    {
        return 0;
    }

    void getSegmentBorders(Situation situation)
    {
        startIndex = getBestIndex(situation, -1);
        if(startIndex == 0)
        {
            Dmin = Math.sqrt(((Observation)log.get(0)).distance(situation));
        }
        else if(startIndex == log.size())
        {
            Dmin = Math.sqrt(((Observation)log.get(log.size()-1)).distance(situation));
        }
        else if(startIndex == (log.size()-1))
        {
            Dmin = Math.min(
                        Math.sqrt(((Observation)log.get(startIndex-1)).distance(situation)),
                        Math.sqrt(((Observation)log.get(startIndex)).distance(situation))
                        );
        }
        else
        {
            Dmin = Math.min(
                            Math.min(
                                Math.sqrt(((Observation)log.get(startIndex-1)).distance(situation)),
                                Math.sqrt(((Observation)log.get(startIndex)).distance(situation))
                                    ), 
                            Math.sqrt(((Observation)log.get(startIndex+1)).distance(situation))
                            );
        }
        
        if(log.size()<SegmentSize)
        {
            startIndex = 0;
            endIndex   = log.size()-1;

            //REPAIR phase
            //seek the worst log entry
            int          Iworst = 0;
            double Dist, Dworst = 0;
            //System.out.println("REPAIRING " + log.size() + " observations");
            for(int i=startIndex; i <= endIndex; i++)
            {
                Dist = ((Observation)log.get(i)).distance(situation);
                if(Dist > Dworst)
                {
                    Dworst = Dist;
                    Iworst = i;
                }
                //System.out.println("i=" + i + " Dist=" + Math.sqrt(Dist) + " Dworst=" + Math.sqrt(Dworst));
            }
            Dmax = Math.sqrt(Dworst);
            //remove this worst log entry from the log, and reinsert it. Hopefully it will be moved to a more suitable neighbourhood.
            repair(Iworst);
            
        }
        else
        {
            endIndex   = startIndex;
            //GROW phase
            double Dprev, Dnext;
            while((endIndex - startIndex + 1) < SegmentSize)
            {
                if(startIndex == 0)
                {
                    endIndex++;
                }
                else if(endIndex >= (log.size()-1))
                {
                    startIndex--;
                }
                else
                {
                    Dprev = ((Observation)log.get(startIndex-1)).distance(situation);
                    Dnext = ((Observation)log.get(endIndex  +1)).distance(situation);
                    if(Dprev < Dnext)
                    {
                        startIndex--;
                    }
                    else
                    {
                        endIndex++;
                    }
                }
            }

            //REPAIR phase
            //seek the worst log entry
            int          Iworst = 0;
            double Dist, Dworst = 0;
            if(endIndex >= log.size())
            {
                System.out.println("fault: start=" + startIndex + " end=" + endIndex);
                endIndex = log.size() - 1;
            }
            for(int i=startIndex; i <= endIndex; i++)
            {
                Dist = ((Observation)log.get(i)).distance(situation);
                if(Dist > Dworst)
                {
                    Dworst = Dist;
                    Iworst = i;
                }
            }
            Dmax = Math.sqrt(Dworst);
            //remove this worst log entry from the log, and reinsert it. Hopefully it will be moved to a more suitable neighbourhood.
            repair(Iworst);
            
            //SHIFT phase
            double Dstart, Dend;
            if(startIndex > 0 & endIndex < log.size()-2)
            {
                Dprev  = ((Observation)log.get(startIndex-1)).distance(situation);
                Dstart = ((Observation)log.get(startIndex  )).distance(situation);
                Dend   = ((Observation)log.get(endIndex    )).distance(situation);
                Dnext  = ((Observation)log.get(endIndex  +1)).distance(situation);
                while((Dprev < Dend) | (Dnext < Dstart))
                {
                    if(Dprev < Dend)
                    {
                        startIndex--;
                        endIndex--;
                    }
                    else
                    {
                        startIndex++;
                        endIndex++;
                    }
                    if(startIndex == 0 | endIndex >= log.size()-1) break;
                    Dprev  = ((Observation)log.get(startIndex-1)).distance(situation);
                    Dstart = ((Observation)log.get(startIndex  )).distance(situation);
                    Dend   = ((Observation)log.get(endIndex    )).distance(situation);
                    Dnext  = ((Observation)log.get(endIndex  +1)).distance(situation);
                }
            }
        }
    }

    public double getDimension(int Dimension, int Index)
    {
        return ((Observation)log.get(Index)).getDimension(Dimension);
    }
    
    public double getProjectedX(int Index, byte ETA, double enemyX, double currentHeading)
    {
        Observation o = (Observation)log.get(Index);
        return o.projectX(enemyX, currentHeading, o.TimeFactor(ETA));
    }
    
    public double getProjectedY(int Index, byte ETA, double enemyY, double currentHeading)
    {
        Observation o = (Observation)log.get(Index);
        return o.projectY(enemyY, currentHeading, o.TimeFactor(ETA));
    }
    
    public int getStart()
    {
        return startIndex;
    }
    
    public int getEnd()
    {
        return endIndex;
    }

    public int getSegmentSize()
    {
        return SegmentSize;
    }
}
