package dsx724;

public class StatsProcessor {
	private int capacity = 1000;
	private boolean[] bulletstat = new boolean[capacity];
	private int hits = 0;
	private int total = 0;
	private boolean DEBUG = false;
	public StatsProcessor(){
		
	}
	public void logBullet(boolean hit){
		if (DEBUG)
			System.out.println("Storing " + hit + " in " + total % capacity + " of " + capacity);
		bulletstat[total % capacity] = hit;
		if (hit)
			hits++;
		total++;
	}
	public double[] getAccuracy(){
		return getAccuracy(total);
	}
	public double[] getAccuracy(int turns){
		turns = Math.min(turns, total);
		if (turns == 0)
			return new double[]{0, 0, 0};
		if (DEBUG)
			System.out.println("Getting Accuracy of " + turns + " turns");
		int loggedhits = 0;
		for (int i = turns; i > 0; i--){
			if (bulletstat[(total - i) % capacity] == true)
				loggedhits++;
		}
		return new double[]{loggedhits * 100 / turns, loggedhits, turns};
	}
	public static void main(String[] args){
		StatsProcessor sp = new StatsProcessor();
		System.out.println("getAccuracy: " + sp.getAccuracy());
		System.out.println("getAccuracy(turns): " + sp.getAccuracy(5));
		//5
		sp.logBullet(true);
		sp.logBullet(true);
		sp.logBullet(false);
		sp.logBullet(true);
		sp.logBullet(true);
		//5
		sp.logBullet(false);
		sp.logBullet(true);
		sp.logBullet(false);
		sp.logBullet(true);
		sp.logBullet(true);
		//5
		sp.logBullet(true);
		sp.logBullet(true);
		sp.logBullet(false);
		sp.logBullet(true);
		sp.logBullet(true);

		System.out.println("getAccuracy: " + sp.getAccuracy());
		System.out.println("getAccuracy(turns): " + sp.getAccuracy(5));
	}
	
	private double[][] pred = new double[capacity][3];
	private int incrementer = -1;
	public void setPrediction(double[] newpred){
		if (incrementer < 0){
			incrementer = 0;
			for (int i = 0; i < pred.length; i++)
				pred[i] = newpred;
		}
		pred[incrementer] = newpred;
		incrementer++;
		if (incrementer == capacity)
			incrementer = 0;
	}
	public double[] incrementTurn(){
		int ret = -1;
		for (int i = 0; i < pred.length; i++){
			pred[i][2]--;
			if (pred[i][2] == 0)
				ret = i;
		}
		if (ret != -1)
			return pred[incrementer];
		else
			return new double[]{0,0,0};
	}
	
	private double[] fireDetect = new double[10000];
	private int fditer = 0;
	public void logFireDetect(double fp){
		fireDetect[fditer++] = fp;
	}
	public int getFD(){
		return fditer;
	}
}
