
package sgp;
import robocode.*;

public class ScanEvent
{
	public double distance;
	public Coordinate position;
	public double relativeHeading_deg;
	public double velocity;
	
	public double time;
	
	static final private double STANDARD_DISTANCE = 50.0;
	static final private double STANDARD_HEADING_DEG = 20.0;
	static final private double STANDARD_VELOCITY = 1.0;
	

	/**
	 * Constructor for ScanEvent.
	 */
	public ScanEvent(Coordinate targetPosition, double relHeading_deg, double v, double theDistance, double robotHeading_deg, double timeStamp)
	{
		distance = theDistance;
		time = timeStamp;
		
		relativeHeading_deg = Strategy.normalRelativeAngle(relHeading_deg);
		
		velocity = v;
		position = new Coordinate(targetPosition);
	}
		
	public double getError(double d, double relHeading_deg, double v)
	{
		double relativeHeadingError = Strategy.normalRelativeAngle(relHeading_deg - relativeHeading_deg);
		return Math.abs(d - distance) / STANDARD_DISTANCE
			+ Math.abs(relativeHeadingError) / STANDARD_HEADING_DEG
			+ Math.abs(v - velocity);
	}

}
