package axeBots.silversurfer;

import java.io.*;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.*;
import java.awt.geom.*;

import axeBots.data.*;
import axeBots.AxeBot;
import axeBots.SilverSurfer;
import axeBots.gunner.*;
import axeBots.util.*;

public class Stratego {
	private boolean antiMirror = false;
	private AxeTarget target = null;
	public static final int MOVE_WALLSWING = 0;
	public static final int MOVE_PREDICTING_STOP = 1;
	public static final int MOVE_PREDICTING_SLOW = 2;
	public static final int MOVE_ON_FIRE = 3;
	public static final int MOVE_TWISTER = 4;
	public static final int MOVE_GIGLE = 5;
	public static final int MOVE_VEER = 6;
	public static final int MOVE_STRATS = 8; //11;
	public static final int MOVE_VAR_SPEED = 7;

	private int moveHited[] = new int[AIM_STRATS];
	private int moveFired[] = new int[AIM_STRATS];
	private double moveDamaged[] = new double[AIM_STRATS];

	public static final int AIM_STATIC = 0; //2;
	public static final int AIM_CIRCULAR_AVG = 1; //4;
	public static final int AIM_CIRCULAR_ACC = 2; //6;
	public static final int AIM_INTERPOLATED_MATCH = 3; //8;
	public static final int AIM_HISTORY_MATCH = 4; //9;
	public static final int AIM_MOVEMENT_ESTIMATED = 5; //10;
	//fora:
	public static final int AIM_LINEAR_ACC = 6; //3;//7;
	public static final int AIM_LINEAR_AVG = 7;
	public static final int AIM_CIRCULAR = 8;
	public static final int AIM_LINEAR = 9;
	public static final int AIM_PATTERN_MATCH = 10;
	public static final int AIM_HEADING_FREE_PM = 11;
	public static final int AIM_ADJUSTED = 12;
	public static final int AIM_VECTOR_PM = 13;
	public static final int AIM_ANTI_MIRROR = 14;

	public static final int AIM_STRATS = 15; //11;
	private int totHits[][] = new int[AIM_STRATS][AIM_ANGLES_QTD];
	private int totFired[][] = new int[AIM_STRATS][AIM_ANGLES_QTD];
	private int totHitsPR[][][] = new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
	private int totFiredPR[][][] = new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
	//[AIM_ANGLES_QTD];
	private int duelTotHits[][] = new int[AIM_STRATS][AIM_ANGLES_QTD];
	private int duelTotFired[][] = new int[AIM_STRATS][AIM_ANGLES_QTD];
	private int duelTotHitsPR[][][] = new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
	private int duelTotFiredPR[][][] = new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
	//[AIM_ANGLES_QTD];
	private int meleeTotHits[][] = new int[AIM_STRATS][AIM_ANGLES_QTD];
	private int meleeTotFired[][] = new int[AIM_STRATS][AIM_ANGLES_QTD];
	private int meleeTotHitsPR[][][] = new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
	//[AIM_ANGLES_QTD];
	private int meleeTotFiredPR[][][] = new int[AIM_STRATS][AIM_ANGLES_QTD][AIM_RANGES_QTD];
	//[AIM_ANGLES_QTD];
	public static final int AIM_RANGES_QTD = 6; //12;
	public static final int AIM_RANGES_WIDTH = 200; //100;
	public static final int AIM_ANGLES_QTD = 4; //100;
	public static final int AIM_ANGLES_WIDTH = 45; //100;

	public static final String TOKEN_VIRGULA = ",";
	public static final String TOKEN_DOIS_PONTOS = ":";
	public static final String TOKEN_BARRA_DIVISAO = "/";
	//private double ranges[] = new double[rangesQtd];
	private int usingAim = /* AIM_MOVEMENT_ESTIMATED; // */
	AIM_CIRCULAR;
	private int misses = 0;
	private int targMissesOnARow = 0;
	private String name = null;
	private PrintStream log = null;
	//private int totPts;
	//private boolean rstPts;
	private boolean duel = false;
	private ArrayList scoring = new ArrayList();
	private AxeScoreReg score = null;
	private int totBots = 0;

	private ArrayList guns = new ArrayList();
	//	firepowercontrol data
	private double firedAtTarget;
	private double damageToTarget;
	private double firedAtMe;
	private double damageToMe;
	private double hitsAtTarget;
	private double hitsAtMe;
	//	firepowercontrol data
	private BotData botData = null;
	//private Vector moveStat = new Vector();
	public static String getStratName(int strat) {
		switch (strat) {
			case AIM_CIRCULAR :
				return "AIM_CIRCULAR";
			case AIM_LINEAR :
				return "AIM_LINEAR";
			case AIM_STATIC :
				return "AIM_STATIC";
			case AIM_CIRCULAR_AVG :
				return "AIM_CIRCULAR_AVG";
			case AIM_LINEAR_AVG :
				return "AIM_LINEAR_AVG";
			case AIM_CIRCULAR_ACC :
				return "AIM_CIRCULAR_ACC";
			case AIM_LINEAR_ACC :
				return "AIM_LINEAR_ACC";
			case AIM_PATTERN_MATCH :
				return "AIM_PATTERN_MATCH";
			case AIM_INTERPOLATED_MATCH :
				return "AIM_INTERPOLATED_MATCH";
			case AIM_HISTORY_MATCH :
				return "AIM_HISTORY_MATCH";
			case AIM_MOVEMENT_ESTIMATED :
				return "AIM_MOVEMENT_ESTIMATED";
			case AIM_HEADING_FREE_PM :
				return "AIM_HEADING_FREE_PM";
			case AIM_ADJUSTED :
				return "AIM_ADJUSTED";
			case AIM_VECTOR_PM :
				return "AIM_VECTOR_PM";
		}
		return "AIM_NOTFOUND";
	}

	public static String getMoveStratName(int strat) {
		switch (strat) {
			case MOVE_WALLSWING :
				return "MOVE_WALLSWING";
			case MOVE_PREDICTING_STOP :
				return "MOVE_PREDICTING_STOP";
			case MOVE_PREDICTING_SLOW :
				return "MOVE_PREDICTING_SLOW";
			case MOVE_ON_FIRE :
				return "MOVE_ON_FIRE";
			case MOVE_TWISTER :
				return "MOVE_TWISTER";
			case MOVE_GIGLE :
				return "MOVE_GIGLE";
			case MOVE_VEER :
				return "MOVE_VEER";
			case MOVE_VAR_SPEED :
				return "MOVE_VAR_SPEED";

		}
		return "MOVE_NOTFOUND";
	}

	public static String getAngleLabel(int strat) {
		switch (strat) {
			case 0 :
				return "FRONTAL";
			case 1 :
				return "ESQUERDA";
			case 2 :
				return "AFASTANDO";
			case 3 :
				return "DIREITA";
		}
		return "NOTFOUND";
	}

	public double setFirePower() {
		return this.getGun().setFirePower(target.getDistance());
	}

	public Stratego(String n, PrintStream inlog, AxeTarget t) {
		this(n, inlog);
		//log = inlog;
		//name = n;
		//reset();
		//resetTots();
		AxeBot me = AxeBot.getIt();
		target = t;

		totBots = me.getTotBots();

		botData = StaticDataCenter.get(n);

		if(!AxeBot.BEE){
			guns.add(new VectorPMGun(t, me, AIM_VECTOR_PM));
			}
		guns.add(new AntiMirrorGun(t, me, AIM_ANTI_MIRROR));

		if ((AxeBot.getIt().getRoundNum() == 0)) {
			if (AxeBot.SAVE_PMGUN_DATA) {

				File f = null;
				while (true) {

					try {
						f = AxeFiles.findBotsFile(name);
						// .getDataFile(dataFileName);
						//loadData(me.getDataFile(dataFileName));
						break;
					} catch (Throwable th) {
						log.println(" XXXXXXXXXXXXXXXXXX loading failed:"
								+ th.getMessage()+th.getStackTrace() );
					}
//					java.io.FilePermission
				}
				loadData(f);

				//			((SilverSurfer)AxeBot.getIt()).getMyPilot().load(name );

			}
			if (AxeBot.LOAD_WS_DATA) {
				botData.getGfHistory().load(name);
			}
		}
		
		
		log.println("CREATING STRATEGO FOR:" + name);
		usingAim = this.topAimStrat();
		//if (me.getRoundNum() == 1) {

		this.resetScores();
		//}

	}

	public Stratego(String n, PrintStream inlog) {
		super();

		name = n;
		log = inlog;
		//log.println("criando: " + name + " at:" + AxeBot.getIt().getTime());
	}

	public void setDuel(boolean d) {
		//log.println("setduela :"+d+" " +duel);
		if (d == duel)
			return;
		duel = d;
		changeDuel(duel);
	}

	public Point2D.Double aim(double firepwr) {
		Point2D.Double ret = null;
		AxeGunner gun = null;
		for (int i = 0; i < guns.size(); i++) {
			gun = (AxeGunner) guns.get(i);
			Point2D.Double pos = gun.aim(firepwr);
			if (gun.getId() == usingAim) {
				ret = pos;
			}
		}

		return ret;
	}

	public AxeGunner getGun() {
		AxeGunner gun = null;
		for (int i = 0; i < guns.size(); i++) {
			gun = (AxeGunner) guns.get(i);
			if (gun.getId() == usingAim) {
				return gun;
			}
		}
		return null;
	}



	public boolean isDuel() {
		return duel;
	}

	public ArrayList[] getDuelAimStats() {
		ArrayList ret[] = new ArrayList[AIM_ANGLES_QTD];

		for (int j = 0; j < AIM_ANGLES_QTD; j++) {
			ret[j] = new ArrayList();
			AxeAimingStrats tot = new AxeAimingStrats(12, "AIM_TOTAIS");
			for (int i = 0; i < AIM_STRATS; i++) {
				AxeAimingStrats aim = new AxeAimingStrats(i, "DUEL "
						+ Stratego.getAngleLabel(j) + " "
						+ Stratego.getStratName(i), duelTotHits[i][j],
						duelTotFired[i][j], duelTotHitsPR[i][j],
						duelTotFiredPR[i][j]);
				tot.add(aim);
				ret[j].add(aim);
			}
			ret[j].add(tot);
		}
		return ret;
	}
	public ArrayList[] getMeleeAimStats() {
		ArrayList ret[] = new ArrayList[AIM_ANGLES_QTD];

		for (int j = 0; j < AIM_ANGLES_QTD; j++) {
			ret[j] = new ArrayList();
			AxeAimingStrats tot = new AxeAimingStrats(12, "AIM_TOTAIS");
			for (int i = 0; i < AIM_STRATS; i++) {
				AxeAimingStrats aim = new AxeAimingStrats(i, "MELEE "
						+ Stratego.getAngleLabel(j) + " "
						+ Stratego.getStratName(i), meleeTotHits[i][j],
						meleeTotFired[i][j], meleeTotHitsPR[i][j],
						meleeTotFiredPR[i][j]);
				tot.add(aim);
				ret[j].add(aim);
			}
			ret[j].add(tot);
		}
		return ret;
	}


	public double getAvgDistHit(AxeTarget t) {
		int ind = getDistInd(t.getDistance());
		int ang = getAngleInd(t.getAngle());
		double ret = (double) totHitsPR[usingAim][ang][ind]
				/ (double) totFiredPR[usingAim][ang][ind];
		ret = (Double.isNaN(ret)) ? 0.00 : ret;
		return ret;
	}



	public double getBestAvg(double dist, double ang) {
		int ind = getDistInd(dist);
		int angInd = getAngleInd(ang);
		double avgs[] = new double[AIM_STRATS];
		for (int i = 0; i < AIM_STRATS; i++) {
			double avg = (double) totHitsPR[i][angInd][ind]
					/ (double) totFiredPR[i][angInd][ind];
			avg = (Double.isNaN(avg)) ? 0.00 : avg;
			avgs[i] = avg;
		}
		return RoboMath.getMax(avgs);
	}

	public void setScore(int pts) {
		//        log.println("STRATEGO SETSCORE: " + pts);
		score.addScore(pts);
		//log.println("===> SCORE: "+score);
	}

	public void setEnemyFired(int mov) {
		this.firedAtMe++;
		if (duel && (AxeBot.getIt().getOthers() > 0)) {
			this.moveFired[mov]++;
		}
	}
	public void setEnemyHitedMe(int mov, double pow) {
		if (AxeBot.getIt().getOthers() > 0) {
			this.damageToMe += pow;
			this.hitsAtMe++;
			score.addDamage(pow);
			if (duel) {
				this.moveHited[mov]++;
				this.moveDamaged[mov] += pow;
			}
		}
	}

	public int getAimStrat() {
		return usingAim;
	}
	public int newAimStrat(AxeTarget t, boolean vbon) {

		return usingAim = (antiMirror) ? AIM_ANTI_MIRROR : AIM_VECTOR_PM; //usingAim;
	}

	private void resetTots() {
		//log.println(" RRRRREEEEESSSSSEEEEETTTTT !!!! ****" );
		//totPts= 0;
		for (int k = 0; k < AIM_ANGLES_QTD; k++) {
			for (int i = 0; i < AIM_STRATS; i++) {
				duelTotHits[i][k] = 0;
				duelTotFired[i][k] = 0;
				for (int j = 0; j < AIM_RANGES_QTD; j++) {
					duelTotHitsPR[i][k][j] = 0;
					duelTotFiredPR[i][k][j] = 0;
				}
			}
			for (int i = 0; i < AIM_STRATS; i++) {
				meleeTotHits[i][k] = 0;
				meleeTotFired[i][k] = 0;
				for (int j = 0; j < AIM_RANGES_QTD; j++) {
					meleeTotHitsPR[i][k][j] = 0;
					meleeTotFiredPR[i][k][j] = 0;
				}
			}
		}
		for (int i = 0; i < MOVE_STRATS; i++) {
			moveFired[i] = 0;
			moveHited[i] = 0;
			moveDamaged[i] = 0;
		}
		int totBots = (AxeBot.getIt()).getTotBots();
		scoring.clear();
		score = new AxeScoreReg(name, totBots);
		score.incRounds();
		scoring.add(score);
		loadDuel(duel);
	}

	public void resetScores() {
		score = new AxeScoreReg(name, totBots);
		score.incRounds();

	}

	public static int getDistInd(double dist) {
		int ind = (int) (dist / Stratego.AIM_RANGES_WIDTH);
		ind = (ind > (AIM_RANGES_QTD - 1)) ? (AIM_RANGES_QTD - 1) : ind;
		return ind;
	}

	public static int getAngleInd(double ang) {
	

		ang = RoboMath.normalRelativeAngle(ang);
		if ((ang > (-45)) && (ang < (45))) {
			return 0;
		} else if ((ang > (45)) && (ang < (135))) {
			return 1;
		} else if ((ang > (135)) || (ang < (-135))) {
			return 2;
		} else if ((ang > (-135)) && (ang < (-45))) {
			return 3;
		} else
			return 4;
	}

	public double getAimTotFiredInRange(AxeTarget t) {
		double ret = 0;

		double fired;

		double dist = t.getDistance();
		int angInd = Stratego.getAngleInd(t.getAngle());
		int distInd = getDistInd(dist);

		for (int i = 0; i < AIM_STRATS; i++) {
			fired = totFiredPR[i][angInd][distInd];
			ret += fired;

		}

		return ret;
	}

	private int topAimStrat() {
		AxeGunner ret;
		ret = (AxeGunner) guns.get(0);
		return (ret.ready()) ? ret.getId() : -1;
	}

	public void missed(BulletTracker bt) {
		int ind = getDistInd(bt.getTargetDist());
		int angInd = Stratego.getAngleInd(bt.getFacingAngle());
		//fired[bt.getAimMethod()]++;
		misses++;
		targMissesOnARow++;
		totFired[bt.getAimMethod()][angInd]++;
		totFiredPR[bt.getAimMethod()][angInd][ind]++;
		/*
		 * if(bt.getAimMethod()==using) { if(misses >= missesChange)
		 * changeStrat(); }
		 */
	}
	public void hit(BulletTracker bt) {
		int ind = getDistInd(bt.getTargetDist());
		int angInd = Stratego.getAngleInd(bt.getFacingAngle());
		misses = 0;
		targMissesOnARow = 0;

		totHits[bt.getAimMethod()][angInd]++;
		totFired[bt.getAimMethod()][angInd]++;
		totHitsPR[bt.getAimMethod()][angInd][ind]++;
		totFiredPR[bt.getAimMethod()][angInd][ind]++;

		this.hitsAtTarget++;
		this.damageToTarget += RoboMath.getBulletDamage(bt.getBullet()
				.getPower());
	}

	private void changeDuel(boolean d) {
		//saveDuel(!d);
		loadDuel(d);
	}

	private void loadDuel(boolean d) {
		if (d) {
			totHits = duelTotHits;
			totFired = duelTotFired;
			totHitsPR = duelTotHitsPR;
			totFiredPR = duelTotFiredPR;
		} else {
			totHits = meleeTotHits;
			totFired = meleeTotFired;
			totHitsPR = meleeTotHitsPR;
			totFiredPR = meleeTotFiredPR;
		}
	}

	public void saveData() {
		DecimalFormat forma = new DecimalFormat("00000");

		File old = AxeFiles.findBotsFile(name);
		if (old != null) {
			if (!old.delete()) {
				log.println("nao deletou!");
			}
		}

		String pre = forma.format(SilverSurfer.getScorer().getELO() * 10000)
				+ "_";
		String dataFileName = pre + AxeFiles.STAT_FILE_PREFIX + name
				+ AxeFiles.STAT_FILE_EXTENSION;

		try {
			GZIPOutputStream zipout = null;

			DataOutputStream w = null;
			int cont = 0;
			while (true) {
				if (cont++ > 10) {
					break;
				}
				try {

					zipout = AxeFiles.getGZipOutputStream(dataFileName);
					//zipout.setLevel(9);
					break;
				} catch (Throwable th) {
					log.println(" XXXXXXXXXXXXXXXXXX saving failed:"
							+ th.getMessage());
				}
			}
			log.println(" XXXXXXXXXXXXXXXXXX saving OK:");
			w = new DataOutputStream(zipout);

			
			w.flush();
			zipout.finish();
			w.close();
		} catch (IOException e) {
			AxeBot.getIt().out.println("IOException trying to write: " + e);
		}
	}

	public void loadData(File f) {

		if ((f == null) || (AxeBot.getIt().getRoundNum() > 0)) {
			return;
		}
		//        log.println(" loading loadData");
		//int firingTypeCount;
		DataInputStream r = null;

		//String dataFileName= STAT_FILE_PREFIX + name + STAT_FILE_EXTENSION;

		try {

			GZIPInputStream zipin = new GZIPInputStream(new FileInputStream(f));
			//zipin.getNextEntry();

			r = new DataInputStream(zipin); //new FileInputStream(f));

			

		} catch (Throwable e) {
			e.printStackTrace(log);
			log.println(" loading failed:" + e.getMessage());

			resetTots();
			botData.reset();
			// Something went wrong reading the file, Start from scratch
			//			initialise();
		} finally {
			try {
				r.close();
			} catch (Throwable e2) {
			};
		}
	}

	/**
	 * @return
	 */
	public AxeScoreReg getScore() {
		return score;
	}
	public ArrayList getAllScores() {
		return scoring;
	}
	public ArrayList getMovings() {
		ArrayList ret = new ArrayList();
		for (int i = 0; i < Stratego.MOVE_STRATS; i++) {
			ret.add(new AxeMovingStrats(Stratego.getMoveStratName(i),
					this.moveFired[i], this.moveHited[i], this.moveDamaged[i]));
		}
		Collections.sort(ret);
		return ret;
	}
	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}

	/**
	 * @return
	 */
	public double getDamageToTarget() {
		return damageToTarget;
	}

	/**
	 * @return
	 */
	public int[][] getDuelTotFired() {
		return duelTotFired;
	}

	/**
	 * @return
	 */
	public double getFiredAtMe() {
		return firedAtMe;
	}

	/**
	 * @return
	 */
	public double getFiredAtTarget() {
		return firedAtTarget;
	}

	/**
	 * @return
	 */
	public double getHitsAtMe() {
		return hitsAtMe;
	}

	/**
	 * @return
	 */
	public double getHitsAtTarget() {
		return hitsAtTarget;
	}

	/**
	 * @param d
	 */
	public void setDamageToTarget(double d) {
		damageToTarget = d;
	}

	/**
	 * @param is
	 */
	public void setDuelTotFired(int[][] is) {
		duelTotFired = is;
	}

	/**
	 * @param d
	 */
	public void setFiredAtMe(double d) {
		firedAtMe = d;
	}

	/**
	 * @param d
	 */
	public void setFiredAtTarget(double d) {
		firedAtTarget = d;
	}

	/**
	 * @param d
	 */
	public void setHitsAtMe(double d) {
		hitsAtMe = d;
	}

	/**
	 * @param d
	 */
	public void setHitsAtTarget(double d) {
		hitsAtTarget = d;
	}
	public String getPowerStats() {
		return this.getName()
				+ " Guns Rating.\r\nMy shots:"
				+ this.firedAtTarget
				+ " hited:"
				+ this.hitsAtTarget
				+ " damaged:"
				+ this.damageToTarget
				+ " Dmg/Hits:"
				+ (RoboMath.bulletDamageToEnergy(this.damageToTarget) / this.hitsAtTarget)
				+ " Dmg/Fired:"
				+ (RoboMath.bulletDamageToEnergy(this.damageToTarget) / this.firedAtTarget)
				+ " Hits/Fired:"
				+ (this.hitsAtTarget / this.firedAtTarget)
				+ "\r\nTargets shots:"
				+ this.firedAtMe
				+ " hited:"
				+ this.hitsAtMe
				+ " damaged:"
				+ this.damageToMe
				+ " Dmg/Hits:"
				+ (RoboMath.bulletDamageToEnergy(this.damageToMe) / this.hitsAtMe)
				+ " Dmg/Fired:"
				+ (RoboMath.bulletDamageToEnergy(this.damageToMe) / this.firedAtMe)
				+ " Hits/Fired:" + (this.hitsAtMe / this.firedAtMe);
	}
	/**
	 * @return
	 */
	public boolean isAntiMirror() {
		return antiMirror;
	}

	/**
	 * @param b
	 */
	public void setAntiMirror(boolean b) {
		antiMirror = b;
	}

}