package ags;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;

import ags.muse.base.BotBase;
import ags.muse.gun.Hypothermia;
import ags.muse.movement.*;
import ags.muse.radar.*;
import ags.muse.recon.*;
import ags.muse.recon.waves.EWaveDetector;
import ags.muse.recon.waves.EnemyTargetingWatcher;
import robocode.Event;

public class Glacier extends BotBase {

    private RobotList robots;
    private MeleeRadar radar;
    private EWaveDetector ewaves;
    private EnemyTargetingWatcher etargeting;
    private CloakedEngine movement;
    private Hypothermia gun;
    
    @Override
    public void _onPaint(Graphics2D g) {
        movement.paint(g);

        ewaves.paint(g);

        etargeting.paint(g);

        g.setColor(Color.green);
        for (EnemyRobot r : robots.getEnemies()) {
            g.drawRect((int)(r.getLocation().x-20+0.5), (int)(r.getLocation().y-20+0.5), 40, 40);
        }
        
        gun.paintTest(g);
    }

    @Override
    public void init() {
        robots = new RobotList(getRules());
        radar = new MeleeRadar(getRules(), robots);
        ewaves = new EWaveDetector(getRules(), robots);
        etargeting = new EnemyTargetingWatcher(ewaves);
        movement = new CloakedEngine(getRules(), robots, ewaves, etargeting);
        gun = new Hypothermia(getRules(), robots);
        
        this.setColors(Color.white, Color.white, Color.white, Color.white);
    }

    @Override
    public void runTick(List<Event> events) {
        // Handle enemy detection
        robots.handleEvents(events);

        // Update enemy waves
        ewaves.update(events);
        
        // Detect enemy targeting
        etargeting.update(events);

        // As long as we've found everyone, start moving
        if (robots.haveFoundAll()) {
          movement.run(getMovementActor());
          gun.run(getGunActor());
        }

        // Run radar controls
        radar.run(getRadarActor(), getGunActor(), getMovementActor());
    }
}
