package is.fon.rs;
import robocode.*;
import java.awt.Color;


// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

/**
 * Kamikaza - a robot by (Dzo)
 */
public class Kamikaza extends Robot
{
	//definisanje promenjljivih
	double ugao;
	double rastojanje;
	double pozicijaX;
	double pozicijaY;
	double pozicijaXmax;
	double pozicijaYmax;
	double idiKaZidu;
	double energija;	


	public void run() {
		//Postavljanje boja za sve delove tenka
		setBodyColor(Color.black);
		setGunColor(Color.white);
		setRadarColor(Color.red);
		setBulletColor(Color.black);
		setScanColor(Color.red);
		
		//Pocetna vrednost pozicije tenka na X osi
		pozicijaX = getX();
		//Pocetna vrednost pozicije tenka na Y osi
		pozicijaY = getY();
		//Maksimalna velicina borbenog polja na X osi
		pozicijaXmax = getBattleFieldWidth();
		//Maksimalna velicina borbenog polja na Y osi
		pozicijaYmax = getBattleFieldHeight();			

		//Ispituje se uslov u kom kvartalu se nalazi tenk, pa u zavisnosti od kvartala vrednost 
		//promenjljive idiKaZidu se menja i pamti radi daljeg kretanja tenka po mapi na osnovu vrednosti promenjljive idiKaZidu
		if(pozicijaX < pozicijaXmax/2 && pozicijaY < pozicijaYmax/2){
			idiKaZidu = Math.max(0, 0);			
		}
	
		if(pozicijaX < pozicijaXmax/2 && pozicijaY > pozicijaYmax/2){
			idiKaZidu = Math.max(0, getBattleFieldHeight());
		}
	
		if(pozicijaX > pozicijaXmax/2 && pozicijaY < pozicijaYmax/2){
			idiKaZidu = Math.max(getBattleFieldWidth(), 0);
		}
	
		if(pozicijaX > pozicijaXmax/2 && pozicijaY > pozicijaYmax/2){
			idiKaZidu = Math.max(getBattleFieldWidth(), getBattleFieldHeight());
		}	
	
		//beskonacna petlja
		while(true) {			
			//Tenk idi napred razlicit broj piksela u zavisnosti od vrednosti promenjljive idiKaZidu
			ahead(idiKaZidu);
			//Kada predje tacno definisan put, onda se okrece u desno pod uglom od 45 stepeni i nastavlja svoje kretanje
			turnRight(45);
			//Tenk okrece cev iz koje puca pod uglom od 360 stepeni
			turnGunRight(360);
		}
	}

    //Metoda kojom tenk skenira druge tenkove i izvrsava odredjene metode
	public void onScannedRobot(ScannedRobotEvent e) {
		//Vrednost ugla na kojoj se nalazi tenk
		ugao = e.getBearing();
		//Vrednost rastojanja na kojoj je udaljen tenk
		rastojanje = e.getDistance();
		
		//Uslov po kome u zavisnosti od ugla tenk puca na drugog tenka sa jacinom metka 3, 1.2 ili 0.5	
		if(ugao < 75){
			fire(3);
		} else if (ugao >= 75 && ugao < 200){
			fire(1.2);
		} else {
			fire(0.5);
		}		
	}

	//Metoda koja se poziva kada se tenk sudari sa drugim tenkom
	public void onHitRobot(HitRobotEvent e) {
		//Vrednost energije koju ima tenk sa kojim smo se sudarili
		energija = e.getEnergy();
		
		//Ako je vrednost energije manja od 20, pucamo na tenk sa metkom jacine 2
		if(energija < 20){
			fire(2);
		}
	
		//Ako je ugao izmedju tenkova izmedju -90 i 90 onda idemo napred za vrednost promenjljive rastojanje
		// i pucamo na tenk sa metkom jacine 3
		if(e.getBearing() > -90 && e.getBearing() < 90){
			ahead(rastojanje);
			//Tenk okrece cev iz koje puca pod uglom od 180 stepeni
			turnGunRight(180);			
			fire(3);
		}
	}	
}
