package suh.targeting;

import java.awt.geom.Point2D;
import robocode.*;
import robocode.util.Utils;
import suh.util.Utility;

public class Wave extends Condition {
    public static final int BINS = 31;
    public static final int MIDDLE_BIN = (BINS - 1) / 2;
    //public static final double MAX_ESCAPE_ANGLE = Math.asin(8.0 / 11.0);
    //public static final double BIN_WIDTH = MAX_ESCAPE_ANGLE / MIDDLE_BIN;
    
    public AdvancedRobot self;
    public static Point2D.Double target;
    public Point2D.Double origin;
    public double velocity;
    public double bearing;
    public double direction;
    public double maxEscapeAngle;
    public int[] stats;
    
    private double distance;
    
    public Wave(AdvancedRobot self, Point2D.Double origin, double direction, double bearing, double velocity, double maxEscapeAngle, int[] stats) {
	this.self = self;
	this.origin = origin;
	this.direction = direction;
	this.bearing = bearing;
	this.velocity = velocity;
	this.maxEscapeAngle = maxEscapeAngle;
	this.stats = stats;
    }
    
    @Override
    public boolean test() {
	distance += velocity;
	if(distance > origin.distance(target) - 18) {
	    stats[currentBin()]++;
	    self.removeCustomEvent(this);
	}
	return false;
    }
    
    protected int currentBin() {
	int bin = (int)Math.round((Utils.normalRelativeAngle(Utility.absoluteBearing(origin, target) - bearing)) / (direction * (maxEscapeAngle / MIDDLE_BIN)) + MIDDLE_BIN);
	return (int)Utility.limit(0, bin, BINS - 1);
    }
    
    protected int mostVisitedBin() {
	int most = MIDDLE_BIN;
	for(int i = 0; i < stats.length; i++) {
	    if(stats[i] > stats[most]) {
		most = i;
	    }
	}
	return most;
    }
    
    public double mostVisitedBearingOffset() {
	return (direction * (maxEscapeAngle / MIDDLE_BIN)) * (mostVisitedBin() - MIDDLE_BIN);
    }
}
