package nz.jdc.micro;

// import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;
import robocode.util.Utils;

/**
 * HedgehogGF 
 * Named by my wife, Yayoi, because hedgehogs are cute. Hopefully this one has some spikes.
 * My fifth bot. Second micro bot.
 * 
 * Firing: Guess Factor Targeting.
 * Movement: Stop and go bullet dodge, or flat/random.
 * 
 * Hmmm. Pretty standard microbot, couldn't find much original to add. Too many cool ideas
 * proved to be flops :(
 * 
 * Credits: 
 * Gun based on Thorn (by Kevin Clark) and RaikoMicro (by Jamougha).
 * Movement is inspired by Waylander, later Cotillion (by Skilgannon) and Weekend Obsession (by Eric Simonton).
 * Lots of other stuff inspired by or borrowed from all the good articles on the wiki.
 *  
 * Version 1.0: 
 *   Codesize : 748
 *   
 * Version 1.1:
 *   No code change, but had to fix a build bug and redeploy a new version  
 *   Codesize : 748
 *   
 * Version 1.2:
 *   Found HedgehogGF to be weak against rammers, so had to add an increase of
 *   bullet power at short range. Unfortunately can no longer fit colour.  
 *   codesize : 749
 *
 * Version 1.3:
 *   Tuned the stop and go movement.
 *   Codesize : 747
 *
 * Version 1.4
 *   Saved a heap of space, so went nuts with scattershot changes...
 *   Altered range control, range segmenting, bullet power and wall segments.
 *   Tuned a bunch of factors and made sacrifices to small gods.
 *   Codesize : 748
 *   
 * Version 1.5
 *   Minor adjustment.
 *   Codesize : 749
 *
 * @author John Cleland 
 */
public class HedgehogGF extends AdvancedRobot {
  
  // for movement -------------------------------------------------------------
  // constants
  private final static double MOVE_DISTANCE    = 105;
  private final static double WALL_STICK       = 160;
  public  final static double SMOOTH_INC       = 0.04;  
  
  private final static double REVERSE_ANGLE    = Math.PI / 4;
  private final static double REVERSE_CHANCE   = 0.62;
  private final static double REVERSE_SUB      = 0.0666;
  
  private final static double HITRATE_FACTOR   = 5.0;
  private final static int    RAM_RANGE        = 121;

  // attributes
  private static double       direction        = 1;
  private static double       enemyBulletVel   = 15.0;
  private static double       flat;
  private static double       enemyEnergy;
  private static double       hitRate;
   
  // for gun ------------------------------------------------------------------
  // constants
  private final static double   BULLET_POWER    = 1.95;
  private final static double   BULLET_VELOCITY = 20 - 3 * BULLET_POWER;
  private final static double   BULLET_DAMAGE   = 4 * BULLET_POWER + 2 * (BULLET_POWER - 1);
  private final static int      MIDDLE_FACTOR   = 25;
  private final static double   MIDDLE_FACT0R   = 24.985;
  private final static int      AIM_FACTORS     = MIDDLE_FACTOR * 2 + 1;
  private final static int      AIM_FACTORS_1   = AIM_FACTORS - 1;
  private final static double   ANGLE_TO_BIN    = 0.04; // .035/4/45 approx asin(8 / BULLET_VELOCITY) / MIDDLE_FACTOR;
  private final static double   MEA_MULT        = 8 / ANGLE_TO_BIN / BULLET_VELOCITY;
  
  private final static double   WALL_FWD        = MEA_MULT * 0.9;
  private final static double   WALL_HALF       = WALL_FWD * .4;
  private final static double   WALL_BACK       = MEA_MULT * -.65;
  // segments
  private final static int      NSEG_DIST       = 5;
  private final static int      NSEG_ACC        = 3;     
  private final static int      NSEG_VEL        = 5;     
  private final static int      NSEG_WALLF      = 3;
  private final static int      NSEG_WALLR      = 2;
    
  // attributes
  private static Point2D.Double  enemyLocation;
  private static int             lastVel;
  private static double          eoDir = 1;
  private static int[][][][][][] data = new int[NSEG_DIST][NSEG_ACC][NSEG_VEL][NSEG_WALLF][NSEG_WALLR][AIM_FACTORS];
  
  //---------------------------------------------------------------------------
  /**
   * called every turn
   */
  public void onStatus(StatusEvent e) {
    // Yayoi says he has to be pink :)
    // but unfortunately I ran out of space :(
    // setBodyColor(Color.PINK);
    
    // helps targeting accuracy
    setAdjustGunForRobotTurn(true);
    
    // necessary for good radar lock
    setAdjustRadarForGunTurn(true);
    
    // start our infinite radar loop
    setTurnRadarRightRadians(1);
  }

//  // testing
//  public void run () { 
//    // testVar = Double.parseDouble(System.getProperty("RUMBLETESTER_PARAM"));
//  }  
  
  /**
   * Scan handler, where it all happens. 
   */
  public void onScannedRobot(ScannedRobotEvent r2e) {
    // register vars
    int    r3i;
    double r4d;
    
    // other vars
    Wave           wave;
    double         absBearing;
    double         headingRadians;
    double         eDistance;
    double         smoothedDir;
    double         latV;
    double         ramming;

    int[]          wgf;
    int            bestGF = MIDDLE_FACTOR;
    
    // common and radar -------------------------------------------------------
    addCustomEvent(wave = new Wave());
    
    // bearing to enemy, location etc
    wave.location = project(0,0);
    
    // r4d is absBearing
    r4d = wave.absoluteBearing = absBearing = r2e.getBearingRadians() + (headingRadians = getHeadingRadians());
    enemyLocation = project(r4d, (eDistance = r2e.getDistance()));

    // do radar scan
    setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle(r4d - getRadarHeadingRadians()));
    // calc enemy latv
    latV = Math.sin(r2e.getHeadingRadians() - r4d) * (r2e.getVelocity());
      
    // movement ---------------------------------------------------------------
    
    // choose preferred direction, perpendicular + range control (r4d)
    r4d = Math.toRadians(T_M_ANGLE.charAt(r3i = (int) eDistance));
    
    // wall smoothing
    while(fieldContains(smoothedDir = absBearing + direction * (r4d -= SMOOTH_INC), WALL_STICK) > 0);
    
    // flat movement reverse chance
    if ((ramming = RAM_RANGE / r3i) +  Math.random() 
        < flat * REVERSE_CHANCE * (REVERSE_SUB - Math.sqrt(enemyBulletVel / eDistance)) 
        || r4d < REVERSE_ANGLE ) {
      direction = -direction;
    }
    
    // back as front turn and random velocity change
    setTurnRightRadians(Math.tan(smoothedDir -= headingRadians));

    // move if flat or bullet detected, with back as front direction control
    if (ramming + (r4d = (enemyEnergy - (enemyEnergy = r2e.getEnergy()))) > flat ) {
      setAhead(Math.copySign(MOVE_DISTANCE - 4 * Rules.getBulletSpeed(r4d), Math.cos(smoothedDir)));
    }
        
    // gun --------------------------------------------------------------------
    
    wave.clockDirection = r4d = (eoDir = Math.signum(latV + eoDir / 100)) * ANGLE_TO_BIN;  // angle to bin includes bullet vel
    
    // choose segments
    wgf = wave.guessFactors = data
      /* dist     */ [r3i / 191] 
      /* acc */      [1 + Integer.signum(lastVel - (lastVel = (int) Math.abs(latV)))]
      /* vel      */ [lastVel / 2]
      /* wall fwd */ [fieldContains(absBearing + (WALL_FWD * r4d), eDistance)  
                    + fieldContains(absBearing + (WALL_HALF * r4d), eDistance)] 
      /* wall bck */ [fieldContains(absBearing + (WALL_BACK * r4d), eDistance)];
    
    // fire bullet with energy control
    if (setFireBullet(Math.min(enemyEnergy / 4, BULLET_POWER + ramming - 3 / getEnergy())) != null) { 
      wave.weighting = 4;
    }

    // aim
    r3i = AIM_FACTORS_1;
    do {
      if (wgf[r3i] > wgf[bestGF]) {
        bestGF = r3i;
      }
    } while(r3i-- > 0);

    // turn gun
    setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing - getGunHeadingRadians() + ((bestGF -  MIDDLE_FACT0R) * r4d)));
  }
  
  /** */
  public void onHitByBullet(HitByBulletEvent e) {
    // credit hit detection from Cotillion by Skilgannon
    enemyEnergy += 20 - (enemyBulletVel = e.getVelocity());
    if(( hitRate += (HITRATE_FACTOR / enemyBulletVel)) > 2 + getRoundNum()) {
       flat = -1;
    }
  }

  /** */
  public void onBulletHit(BulletHitEvent e) {
    enemyEnergy -= BULLET_DAMAGE;
  }
  
  /** @return 0 if in the battlefield, 1 if outside */
  private int fieldContains(double heading, double distance) {
    return Integer.signum(new Rectangle2D.Double(18, 18, 764, 564).outcode(project(heading, distance)));
  }
  
  /** project a point */
  private Point2D.Double project(double angle, double distance) {
    return new Point2D.Double(getX() + distance * Math.sin(angle), getY() + distance * Math.cos(angle));
  }

  // Wave inner class ---------------------------------------------------------
  public class Wave extends Condition {
    Point2D.Double location;
    int[]  guessFactors;
    double clockDirection;
    double absoluteBearing; 
    double distance;
    int    weighting;
    
    public boolean test() {
      if (enemyLocation.distance(location) <= (distance += BULLET_VELOCITY)) {
        guessFactors[MIDDLE_FACTOR + (int)(Utils.normalRelativeAngle(Math.atan2(enemyLocation.x - location.x, enemyLocation.y - location.y) - absoluteBearing) / clockDirection)] += 1 + weighting;
        removeCustomEvent(this);
      }
      return false;
    }
  }
  
  // tables -------------------------------------------------------------------
  private final static String T_M_ANGLE = ""
    // 0 - 50  165  extreme ram avoid
    + "\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7\u00a7"
    // 50 - 100  150  ram avoid
    + "\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098"
    + "\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098\u0098"
    // 100 - 160  135  strong extend
    + "\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089"
    + "\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089\u0089"
    // 160 - 250  120  extend
    + "zzzzzzzzzzzzzzzzzzzz"
    + "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz"
    + "zzzzzzzzzz"
    // 250 - p    110  mild extend - adjust this segment size to tune ranging 
    + "pppppppppppppppppppppppppppppppppppppppppppppppppp"
    + "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp"
    + "pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp"
    // the preferred range bracket
    + "ffffffffffffffffffffffffffffff\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"
    + "RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH"
    // large buffer of close to fill out and allow for size adj in the mild-extend
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>"
    + ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>";
}
