/*
 * Decompiled with CFR 0.152.
 */
package mladjo;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class GnuKlub
extends AdvancedRobot {
    List waves = new ArrayList();
    static int[] stats = new int[31];
    int direction = 1;
    double guessfactor;
    static final int LOG_SIZE = 30;
    private static double lastEnemyHeading;
    private static double enemyLog;
    public static int BINS;
    public static double[] _surfStats;
    public Point2D.Double _myLocation;
    public Point2D.Double _enemyLocation;
    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;
    public static double _oppEnergy;
    public Rectangle2D.Double _fieldRect;
    public static double WALL_STICK;

    static {
        BINS = 47;
        _surfStats = new double[BINS];
        _oppEnergy = 100.0;
        WALL_STICK = 160.0;
    }

    public void run() {
        this._enemyWaves = new ArrayList();
        this._surfDirections = new ArrayList();
        this._surfAbsBearings = new ArrayList();
        this._fieldRect = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        this.setBodyColor(Color.cyan);
        this.setGunColor(Color.cyan);
        this.setScanColor(Color.cyan);
        this.setRadarColor(Color.cyan);
        this.setBulletColor(Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this._myLocation = new Point2D.Double(this.getX(), this.getY());
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this._surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        this._surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this._surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = GnuKlub.bulletVelocity(bulletPower);
            ew.distanceTraveled = GnuKlub.bulletVelocity(bulletPower);
            ew.direction = (Integer)this._surfDirections.get(2);
            ew.directAngle = (Double)this._surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._enemyLocation.clone();
            this._enemyWaves.add(ew);
        }
        _oppEnergy = e.getEnergy();
        this._enemyLocation = GnuKlub.project(this._myLocation, absBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
        this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
        double ex = this.getX() + Math.sin(absBearing) * e.getDistance();
        double ey = this.getY() + Math.cos(absBearing) * e.getDistance();
        int i = 0;
        while (i < this.waves.size()) {
            WaveBullet currentWave = (WaveBullet)this.waves.get(i);
            if (currentWave.checkHit(ex, ey, this.getTime())) {
                this.waves.remove(currentWave);
                --i;
            }
            ++i;
        }
        double power = Math.min(3.0, e.getEnergy() / 5.0);
        if (e.getVelocity() != 0.0) {
            this.direction = Math.sin(e.getHeadingRadians() - absBearing) * e.getVelocity() < 0.0 ? -1 : 1;
        }
        int[] currentStats = stats;
        WaveBullet newWave = new WaveBullet(this.getX(), this.getY(), absBearing, power, this.direction, this.getTime(), currentStats);
        int bestindex = 15;
        int i2 = 0;
        while (i2 < 31) {
            if (currentStats[bestindex] < currentStats[i2]) {
                bestindex = i2;
            }
            ++i2;
        }
        this.guessfactor = (double)(bestindex - (stats.length - 1) / 2) / (double)((stats.length - 1) / 2);
        double angleOffset = (double)this.direction * this.guessfactor * newWave.maxEscapeAngle();
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians() + angleOffset)));
        if (this.setFireBullet(power) != null) {
            this.waves.add(newWave);
        }
    }

    public void updateWaves() {
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this._myLocation.distance(ew.fireLocation) + 50.0) {
                this._enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = GnuKlub.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / GnuKlub.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)GnuKlub.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = GnuKlub.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            int n = x;
            _surfStats[n] = _surfStats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) < 50.0 && Math.round(GnuKlub.bulletVelocity(e.getBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void onWin(WinEvent e) {
        this.setBodyColor(Color.red);
        this.setGunColor(Color.red);
        this.setScanColor(Color.red);
        this.setRadarColor(Color.red);
        this.setBulletColor(Color.white);
        int i = 0;
        while (i < 200) {
            this.turnLeft(40.0);
            this.turnGunRight(40.0);
            ++i;
        }
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, GnuKlub.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + GnuKlub.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = GnuKlub.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = GnuKlub.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = GnuKlub.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return _surfStats[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = GnuKlub.absoluteBearing(surfWave.fireLocation, this._myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this._myLocation, goAngle - 1.5707963267948966, -1) : this.wallSmoothing(this._myLocation, goAngle + 1.5707963267948966, 1);
        GnuKlub.setBackAsFront(this, goAngle);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!this._fieldRect.contains(GnuKlub.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
    }

    public class WaveBullet {
        private double startx;
        private double starty;
        private double startBearing;
        private double power;
        public long fireTime;
        private int direction;
        private int[] returnSegment;

        public WaveBullet(double x, double y, double bearing, double power, int direction, long time, int[] segment) {
            this.startx = x;
            this.starty = y;
            this.startBearing = bearing;
            this.power = power;
            this.direction = direction;
            this.fireTime = time;
            this.returnSegment = segment;
        }

        public double getBulletSpeed() {
            return 20.0 - this.power * 3.0;
        }

        public double maxEscapeAngle() {
            return Math.asin(8.0 / this.getBulletSpeed());
        }

        public boolean checkHit(double enemyX, double enemyY, long currentTime) {
            if (Point2D.distance(this.startx, this.starty, enemyX, enemyY) <= (double)(currentTime - this.fireTime) * this.getBulletSpeed()) {
                int index;
                double desiredDirection = Math.atan2(enemyX - this.startx, enemyY - this.starty);
                double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - this.startBearing));
                double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / this.maxEscapeAngle())) * (double)this.direction;
                int n = index = (int)Math.round((double)((this.returnSegment.length - 1) / 2) * (guessFactor + 1.0));
                this.returnSegment[n] = this.returnSegment[n] + 1;
                return true;
            }
            return false;
        }
    }
}

