/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.data;

import java.util.List;
import xander.core.Resources;
import xander.core.track.BulletShadow;
import xander.core.track.Wave;
import xander.gfws.FactorArrays;
import xander.gfws.data.CachingFactorArrayProcessor;
import xander.gfws.data.DataPoint;
import xander.gfws.data.FactorArrayParms;
import xander.gfws.data.LogReader;

public class DataPointFactorArrayProcessor
extends CachingFactorArrayProcessor {
    private int factors;
    private FactorArrayParms parms;
    private LogReader logReader;
    private int flattenerOn;
    private int flattenerOff;
    private double myHitRatio;
    private double oppHitRatio;

    public DataPointFactorArrayProcessor(LogReader logReader, int factors, FactorArrayParms parms) {
        super(factors);
        this.logReader = logReader;
        this.factors = factors;
        this.parms = parms;
    }

    public double getFlattenerUsePercentage() {
        int totalCount = this.flattenerOn + this.flattenerOff;
        return totalCount == 0 ? 0.0 : (double)this.flattenerOn / (double)totalCount;
    }

    private void addFactorArrayPoint(double[] factorArray, FactorArrayParms parms, double cweight, DataPoint dataPoint, long referenceTime) {
        if (parms.varyWeightByAge) {
            cweight = parms.useCreativeAgeRoll && this.myHitRatio > this.oppHitRatio + 0.01 ? (cweight *= Math.max(parms.minAgeWeightPercent, 1.0 - parms.decayPerTick * (double)(Resources.getTime() - dataPoint.roundTime))) : (cweight *= Math.max(parms.minAgeWeightPercent, 1.0 - parms.decayPerTick * (double)(referenceTime - dataPoint.logTime)));
        }
        double preciseFactorIndex = dataPoint.getFactorIndex(this.factors);
        parms.distributer.addWeight(factorArray, preciseFactorIndex, cweight, dataPoint.distance, dataPoint.bulletVelocity, dataPoint.surfDirection);
    }

    @Override
    public void fillFactorArray(double[] factorArray, Wave surfWave, double minFactorAngle, double maxFactorAngle) {
        boolean useFlattenerThisWave;
        long cumulativeTime = Resources.getCumulativeTime();
        List<DataPoint> knnHitData = this.logReader.getHitData(surfWave).getResultList();
        int counter = 0;
        this.oppHitRatio = Resources.getGunStats().getOverallOpponentHitRatio();
        this.myHitRatio = Resources.getGunStats().getOverallHitRatio();
        boolean bl = useFlattenerThisWave = this.parms.useFlattener && this.oppHitRatio > this.parms.useFlattenerOnHitPercentage && this.myHitRatio < this.oppHitRatio && Resources.getRobotProxy().getRoundNum() >= this.parms.useFlattenerEarliestRound;
        if (useFlattenerThisWave) {
            ++this.parms.flattenerOnCount;
            ++this.flattenerOn;
        } else {
            ++this.parms.flattenerOffCount;
            ++this.flattenerOff;
        }
        long referenceTime = 0L;
        for (DataPoint dataPoint : knnHitData) {
            referenceTime = Math.max(referenceTime, dataPoint.logTime);
        }
        double rankMultiplier = 1.0;
        for (DataPoint dataPoint : knnHitData) {
            double rankWeight = this.parms.weight * rankMultiplier;
            this.addFactorArrayPoint(factorArray, this.parms, rankWeight, dataPoint, referenceTime);
            rankMultiplier *= this.parms.varyWeightByRankMultiplier;
            ++counter;
        }
        if (useFlattenerThisWave) {
            double cweight = this.parms.weight * this.parms.useFlattenerVisitPercentage;
            List<DataPoint> knnVisitData = this.logReader.getVisitData(surfWave).getResultList();
            for (DataPoint visitDataPoint : knnVisitData) {
                this.addFactorArrayPoint(factorArray, this.parms, cweight, visitDataPoint, cumulativeTime);
            }
        }
        if (counter <= this.parms.maxDataPointsForUsingArrayInitializer) {
            this.parms.arrayInitializer.modify(factorArray, surfWave);
            ++counter;
        }
        if (this.parms.useBulletShadows) {
            for (BulletShadow shadow : surfWave.getBulletShadows()) {
                double ccwShadowFactorAngle = FactorArrays.getFactorAngle(surfWave, shadow.getCounterClockwiseAngle());
                double cwShadowFactorAngle = FactorArrays.getFactorAngle(surfWave, shadow.getClockwiseAngle());
                double ccwShadowIndex = FactorArrays.getPreciseFactorIndex(ccwShadowFactorAngle, factorArray.length, surfWave.getBulletVelocity(), surfWave.getSurfDirection());
                double cwShadowIndex = FactorArrays.getPreciseFactorIndex(cwShadowFactorAngle, factorArray.length, surfWave.getBulletVelocity(), surfWave.getSurfDirection());
                double pBeginIndex = cwShadowIndex > ccwShadowIndex ? ccwShadowIndex : cwShadowIndex;
                double pEndIndex = cwShadowIndex > ccwShadowIndex ? cwShadowIndex : ccwShadowIndex;
                int beginIndex = (int)Math.round(Math.ceil(pBeginIndex));
                int endIndex = (int)Math.round(Math.floor(pEndIndex));
                int i = beginIndex;
                while (i < endIndex) {
                    if (i >= 0 && i < factorArray.length) {
                        factorArray[i] = 0.0;
                    }
                    ++i;
                }
                if (beginIndex - 1 >= 0) {
                    double f = 1.0 - ((double)beginIndex - pBeginIndex);
                    int n = beginIndex - 1;
                    factorArray[n] = factorArray[n] * f;
                }
                if (endIndex + 1 >= factorArray.length) continue;
                double f = 1.0 - (pEndIndex - (double)endIndex);
                int n = endIndex + 1;
                factorArray[n] = factorArray[n] * f;
            }
        }
    }
}

