/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.gun.power;

import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.gun.power.PowerSelector;
import xander.core.track.GunStats;
import xander.core.track.Snapshot;

public class SteppedHitRatioPowerSelector
implements PowerSelector {
    private double[] stepHitRatios;
    private double[] stepFirePowers;
    private double minPower = 3.0;
    private double maxPower = 0.1;
    private GunStats gunStats;
    private RobotProxy robotProxy;
    private double dropPowerHitRatio = 1.0;
    private double dropPowerEnergyLead;
    private double dropPowerBy;
    private int dropPowerCount;

    public SteppedHitRatioPowerSelector(double[] stepHitRatios, double[] stepFirePowers) {
        int i = 0;
        while (i < stepHitRatios.length - 1) {
            if (stepHitRatios[i + 1] < stepHitRatios[i]) {
                throw new IllegalArgumentException("stepHitRatios must be in ascending order.");
            }
            ++i;
        }
        if (stepFirePowers.length != stepHitRatios.length + 1) {
            throw new IllegalArgumentException("stepFirePowers must contain one more element than stepHitRatios");
        }
        i = 0;
        while (i < stepFirePowers.length) {
            this.minPower = Math.min(this.minPower, stepFirePowers[i]);
            this.maxPower = Math.max(this.maxPower, stepFirePowers[i]);
            ++i;
        }
        this.stepFirePowers = stepFirePowers;
        this.stepHitRatios = stepHitRatios;
    }

    public void setPowerDrop(double dropPowerHitRatio, double dropPowerEnergyLead, double dropPowerBy) {
        this.dropPowerHitRatio = dropPowerHitRatio;
        this.dropPowerEnergyLead = dropPowerEnergyLead;
        this.dropPowerBy = dropPowerBy;
    }

    @Override
    public double getFirePower(Snapshot target) {
        double energyLead;
        if (this.gunStats == null) {
            this.robotProxy = Resources.getRobotProxy();
            this.gunStats = Resources.getGunStats();
        }
        double hitRatio = this.gunStats.getOverallHitRatio();
        int i = 0;
        while (i < this.stepHitRatios.length && hitRatio > this.stepHitRatios[i]) {
            ++i;
        }
        double firePower = this.stepFirePowers[i];
        if (hitRatio <= this.dropPowerHitRatio && (energyLead = this.robotProxy.getEnergy() - target.getEnergy()) >= this.dropPowerEnergyLead && firePower > this.gunStats.getRollingAverageOpponentBulletPower()) {
            ++this.dropPowerCount;
            firePower = this.dropPowerBy == 0.0 ? this.gunStats.getRollingAverageOpponentBulletPower() : (firePower -= this.dropPowerBy);
        }
        return firePower;
    }

    public int getDropPowerCount() {
        return this.dropPowerCount;
    }

    @Override
    public double getMinimumPower() {
        return this.minPower;
    }

    @Override
    public double getMaximumPower() {
        return this.maxPower;
    }

    @Override
    public boolean isAutoAdjustAllowed() {
        return true;
    }
}

