/*
 * Decompiled with CFR 0.152.
 */
package xander.core.gun.detect;

import xander.core.gun.detect.TargetingDetector;
import xander.core.math.Linear;
import xander.core.math.LinearIntercept;
import xander.core.track.Wave;

public class LinearDetector
extends TargetingDetector {
    public LinearDetector(boolean offensive) {
        super("Linear Detector", offensive);
    }

    @Override
    public double getDetectionAngle(Wave wave) {
        LinearIntercept linearTrajectory = Linear.calculateTrajectory(wave.getInitialDefenderSnapshot(), wave.getOriginX(), wave.getOriginY(), wave.getBulletVelocity(), this.robotProxy.getBattleFieldSize(), wave.getOriginTime());
        return linearTrajectory == null ? -1.0 : linearTrajectory.getVelocityVector().getRoboAngle();
    }

    @Override
    protected double getSloppyAimTolerance() {
        return 20.0;
    }
}

