/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import robocode.util.Utils;
import tcf.Bot;
import tcf.GfBase;
import tcf.Prediction;
import tcf.Seg;
import tcf.SimpleSeg;
import tcf.StaticStore;
import tcf.TestGf;

class GuessFactor
implements GfBase {
    static final int STEPS = 35;
    static final double MIN = 0.0;
    static final double MAX = 1.0;
    static final int N_SEGS = 4;
    Seg m_gfSeg = new SimpleSeg(0.0, 1.0, 35);
    Seg[] m_segs = new Seg[4];
    int[] m_dimSize = new int[4];
    int[][] m_hit;
    int[] m_count;

    GuessFactor(String string, Seg[] segArray) {
        int n;
        this.m_segs = segArray;
        int n2 = 1;
        for (n = 0; n < 4; ++n) {
            this.m_dimSize[n] = n2;
            if (this.m_segs[n] == null) continue;
            n2 *= this.m_segs[n].nBins();
        }
        if (StaticStore.get(string + ".hit") != null) {
            this.m_hit = (int[][])StaticStore.get(string + ".hit");
            this.m_count = (int[])StaticStore.get(string + ".count");
        } else {
            this.m_hit = new int[n2][35];
            this.m_count = new int[n2];
            StaticStore.put(string + ".hit", this.m_hit);
            StaticStore.put(string + ".count", this.m_count);
            for (n = 0; n < n2; ++n) {
                this.m_hit[n][17] = 1;
            }
        }
    }

    public int segIndex(double[] dArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.m_segs[i] == null) continue;
            n += this.m_dimSize[i] * this.m_segs[i].seg(dArray[i]);
        }
        return n;
    }

    public int itemSegIndex(int n, double d) {
        if (this.m_segs[n] == null) {
            return -1;
        }
        return this.m_segs[n].seg(d);
    }

    public void learn(double[] dArray, double d) {
        int n = this.segIndex(dArray);
        int n2 = this.m_gfSeg.seg(d);
        int[] nArray = this.m_hit[n];
        int n3 = n2;
        nArray[n3] = nArray[n3] + 1;
        int n4 = n;
        this.m_count[n4] = this.m_count[n4] + 1;
    }

    public void predict(double[] dArray, Prediction prediction) {
        throw new RuntimeException("GuessFactor.predict() is not implemented");
    }

    public double best(double[] dArray, double d, TestGf testGf) {
        int n = this.segIndex(dArray);
        int[] nArray = this.m_hit[n];
        int n2 = this.bestIndex(nArray);
        return 0.0 + ((double)n2 + 0.5) * 0.02857142857142857;
    }

    public int bestIndex(int[] nArray) {
        int n = 17;
        int n2 = 0;
        int n3 = 0;
        for (int i = 34; i >= 0; --i) {
            int n4 = 0;
            if (i > 0) {
                n4 += nArray[i - 1];
            }
            if (i < 34) {
                n4 += nArray[i + 1];
            }
            if (n2 >= nArray[i] && (n2 != nArray[i] || n3 >= n4)) continue;
            n2 = nArray[i];
            n3 = n4;
            n = i;
        }
        return n;
    }

    private int value(int[] nArray, int n) {
        int n2 = nArray[n] * 2;
        if (n2 != 0) {
            if (n > 0) {
                n2 += nArray[n - 1];
            }
            if (n < 34) {
                n2 += nArray[n + 1];
            }
        }
        return n2;
    }

    public double[][] bestList(double[] dArray) {
        int n;
        int n2 = this.segIndex(dArray);
        int[] nArray = this.m_hit[n2];
        int[] nArray2 = new int[11];
        int[] nArray3 = new int[11];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 35; ++i) {
            int n6;
            n = this.value(nArray, i);
            if (n <= 0 || n < n5) continue;
            if (n3 >= nArray2.length) {
                for (n6 = 0; n6 < n3; ++n6) {
                    if (nArray2[n6] != n5) continue;
                    nArray2[n6] = nArray2[--n3];
                    nArray3[n6] = nArray3[n3];
                    break;
                }
            }
            nArray2[n3] = n;
            nArray3[n3] = i;
            ++n3;
            if (n4 < n) {
                n4 = n;
            }
            n5 = Integer.MAX_VALUE;
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = Math.min(n5, nArray2[n6]);
            }
        }
        if (n3 == 0) {
            nArray2[n3] = 1;
            nArray3[n3] = 17;
            ++n3;
            n4 = 1;
        }
        double[][] dArray2 = new double[2][n3];
        for (n = 0; n < n3; ++n) {
            dArray2[0][n] = 0.0 + ((double)nArray3[n] + 0.5) * 0.02857142857142857;
            dArray2[1][n] = (double)nArray2[n] / (double)n4;
        }
        return dArray2;
    }

    public static double binToGf(int n) {
        double d = ((double)n + 0.5) / 35.0;
        return d;
    }

    public static double gfToAngle(double d, double d2, double d3) {
        double d4 = d3 + d * (d2 - d3);
        return d4;
    }

    public static double angleToGf(double d, double d2, double d3) {
        double d4 = (d - d3) / (d2 - d3);
        return d4;
    }

    public static double calcAngle(boolean bl, Bot bot, double d, Bot bot2) {
        return GuessFactor.calcAngle(bl, bot2.x(), bot2.y(), bot2.heading(), bot2.speed(), bot.x(), bot.y(), d);
    }

    public static double calcAngle(boolean bl, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9 = d3 - Math.atan2(d - d5, d2 - d6);
        double d10 = d8 = d4 * Math.sin(d9);
        double d11 = Math.hypot(d - d5, d2 - d6);
        double d12 = d11 * d11;
        double d13 = d7 * d7;
        double d14 = 0.0;
        int n = 0;
        while (d14 * d14 > d13 * (double)n * (double)n - d12) {
            double d15;
            if (bl == d10 >= 0.0) {
                d15 = d8 >= 0.0 ? 1.0 : 2.0;
                d8 = Math.min(8.0, d8 + d15);
            } else {
                d15 = d8 <= 0.0 ? -1.0 : -2.0;
                d8 = Math.max(-8.0, d8 + d15);
            }
            d14 += d8;
            ++n;
        }
        double d16 = Math.atan(d14 / d11);
        return d16;
    }

    public static double newBrokenCalcAngle(boolean bl, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9 = Math.atan2(d - d5, d2 - d6);
        double d10 = Utils.normalRelativeAngle((double)(d3 - d9));
        double d11 = d8 = d4 * Math.sin(d10) >= 0.0 ? 1.0 : -1.0;
        if (!bl) {
            d8 = -d8;
        }
        double d12 = d4 * d8;
        double d13 = Math.hypot(d - d5, d2 - d6);
        if (bl == d12 > 0.0) {
            return Math.asin(8.0 / d7);
        }
        return -Math.asin(8.0 / d7);
    }
}

