/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import metal.shared.MChromosoom;
import metal.shared.MMath;

public class MDna {
    private TreeMap chromosooms = new TreeMap();
    public int counter = 0;

    public MDna() {
        this.addChromosoom("-2", -35.0, -40.0, -29.0);
        this.addChromosoom("-1", -6.0, -25.0, -15.0);
        this.addChromosoom("0", 15.0, -8.0, 4.0);
        this.addChromosoom("1", 6.0, 12.0, 20.0);
        this.addChromosoom("2", 38.0, 25.0, 40.0);
    }

    public MChromosoom getFittest() {
        return (MChromosoom)Collections.max(this.chromosooms.values());
    }

    public void addChromosoom(String chromosoom, double init, double min, double max) {
        MChromosoom c = new MChromosoom(init, min, max, Double.valueOf(chromosoom));
        if (chromosoom.equals("-1") || chromosoom.equals("1")) {
            c.fitness = -2;
        }
        if (chromosoom.equals("0")) {
            c.fitness = -5;
        }
        this.chromosooms.put(chromosoom, c);
    }

    public double[] furtilize() {
        double[] sperm = new double[this.chromosooms.size() * 3];
        for (int i = 0; i < 3; ++i) {
            int k = 0;
            int begin = this.chromosooms.size() * i;
            Iterator j = this.chromosooms.values().iterator();
            while (j.hasNext()) {
                MChromosoom item = (MChromosoom)j.next();
                sperm[begin + k] = item.value;
                ++k;
            }
        }
        return sperm;
    }

    public void mutate(String chromosoom) {
        MChromosoom c = (MChromosoom)this.chromosooms.get(chromosoom);
        c.value = MMath.random(c.min, c.max);
        this.chromosooms.put(chromosoom, c);
    }

    public void mergeDna(double[] sperm) {
        int i = 0;
        double val = 0.0;
        boolean decided = false;
        Iterator j = this.chromosooms.values().iterator();
        while (j.hasNext()) {
            MChromosoom chromosoom = (MChromosoom)j.next();
            if (sperm[i] == sperm[this.chromosooms.size() + i]) {
                val = sperm[i];
                decided = true;
            } else if (sperm[i] == sperm[this.chromosooms.size() * 2 + i]) {
                val = sperm[i];
                decided = true;
            } else if (sperm[this.chromosooms.size() + i] == sperm[this.chromosooms.size() * 2 + i]) {
                val = sperm[this.chromosooms.size() + i];
                decided = true;
            }
            chromosoom.value = decided && val > chromosoom.min && val < chromosoom.max ? this.addReplicationErrors(val) : MMath.random(chromosoom.min, chromosoom.max);
            ++i;
        }
    }

    private double addReplicationErrors(double value) {
        Random random = new Random();
        int nr = (int)random.nextDouble() * 2;
        if (nr == 1) {
            return value + random.nextDouble() * 2.0 - 1.0;
        }
        return value;
    }

    public MChromosoom getChromosoom(String chromosoom) {
        return (MChromosoom)this.chromosooms.get(chromosoom);
    }

    public MChromosoom getChromosoom(int chromosoom) {
        return (MChromosoom)this.chromosooms.get(chromosoom + "");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Name\t\tValue\tInitial\tMin\tMax\n");
        Iterator i = this.chromosooms.keySet().iterator();
        while (i.hasNext()) {
            String c = (String)i.next();
            sb.append(c);
            sb.append("\t");
            sb.append((MChromosoom)this.chromosooms.get(c));
        }
        return sb.toString();
    }
}

