/*
 * Decompiled with CFR 0.152.
 */
package de.simpleworks.robocode.botUtil;

import de.simpleworks.robocode.botUtil.Coordinate;

public class CsCalc {
    private static double calcAlpha(double _heading) {
        if (_heading < 90.0) {
            return 90.0 - _heading;
        }
        if (_heading < 180.0) {
            return _heading - 90.0;
        }
        if (_heading < 270.0) {
            return 90.0 - (_heading - 180.0);
        }
        return _heading - 270.0;
    }

    private static double calcXOffset(double _distance, double _heading) {
        double alpha = CsCalc.calcAlpha(_heading);
        double beta = 90.0 - alpha;
        if (_heading == 0.0 || _heading == 180.0) {
            return 0.0;
        }
        if (_heading == 90.0 || _heading == 270.0) {
            return _distance;
        }
        return Math.sin(Math.toRadians(beta)) * _distance;
    }

    private static double calcYOffset(double _distance, double _heading) {
        double alpha = CsCalc.calcAlpha(_heading);
        if (_heading == 0.0 || _heading == 180.0) {
            return _distance;
        }
        if (_heading == 90.0 || _heading == 270.0) {
            return 0.0;
        }
        return Math.sin(Math.toRadians(alpha)) * _distance;
    }

    public static Coordinate calcEndPoint(Coordinate _startPoint, double _distance, double _heading) {
        double epX = 0.0;
        double epY = 0.0;
        if (_heading < 90.0) {
            epX = _startPoint.x() + CsCalc.calcXOffset(_distance, _heading);
            epY = _startPoint.y() + CsCalc.calcYOffset(_distance, _heading);
            return new Coordinate(epX, epY);
        }
        if (_heading < 180.0) {
            epX = _startPoint.x() + CsCalc.calcXOffset(_distance, _heading);
            epY = _startPoint.y() - CsCalc.calcYOffset(_distance, _heading);
            return new Coordinate(epX, epY);
        }
        if (_heading < 270.0) {
            epX = _startPoint.x() - CsCalc.calcXOffset(_distance, _heading);
            epY = _startPoint.y() - CsCalc.calcYOffset(_distance, _heading);
            return new Coordinate(epX, epY);
        }
        epX = _startPoint.x() - CsCalc.calcXOffset(_distance, _heading);
        epY = _startPoint.y() + CsCalc.calcYOffset(_distance, _heading);
        return new Coordinate(epX, epY);
    }

    public static double calcTargetAngle(Coordinate _startPoint, Coordinate _endPoint) {
        double xDiff = _endPoint.x() - _startPoint.x();
        double yDiff = _endPoint.y() - _startPoint.y();
        if (xDiff == 0.0) {
            if (yDiff > 0.0) {
                return 0.0;
            }
            return 180.0;
        }
        if (yDiff == 0.0) {
            if (xDiff > 0.0) {
                return 90.0;
            }
            return 270.0;
        }
        double c = CsCalc.calcDistance(_startPoint, _endPoint);
        double a = Math.abs(yDiff);
        double alpha = Math.asin(a / c);
        alpha = Math.toDegrees(alpha);
        if (xDiff > 0.0 && yDiff < 0.0) {
            return alpha + 90.0;
        }
        if (xDiff < 0.0 && yDiff < 0.0) {
            return 270.0 - alpha;
        }
        if (xDiff < 0.0 && yDiff > 0.0) {
            return alpha + 270.0;
        }
        return 90.0 - alpha;
    }

    public static double calcDistance(Coordinate _startPoint, Coordinate _endPoint) {
        double xDiff = _startPoint.x() - _endPoint.x();
        double yDiff = _startPoint.y() - _endPoint.y();
        if (xDiff == 0.0) {
            return Math.abs(yDiff);
        }
        if (yDiff == 0.0) {
            return Math.abs(xDiff);
        }
        double a = Math.abs(yDiff);
        double b = Math.abs(xDiff);
        return Math.sqrt(a * a + b * b);
    }
}

