/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules.artillery.strategies;

import ghent.common.Target;
import ghent.modules.artillery.TimestampedLocation;
import ghent.modules.artillery.strategies.AbstractTargetingStrategy;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Rules;

public class CircularTargeting
extends AbstractTargetingStrategy {
    static final double ROBOT_HALF_WIDTH = 8.0;
    static final double ROBOT_HALF_HEIGHT = 8.0;

    public CircularTargeting(AdvancedRobot robot) {
        super(robot);
    }

    public CircularTargeting(AdvancedRobot _robot, Double _maxPower) {
        super(_robot, _maxPower);
    }

    public TimestampedLocation getEstimatedLocation(Target enemy, double bPower) {
        double endY;
        double endX;
        double deltaTime;
        block2: {
            if (enemy == null) {
                return null;
            }
            double BATTLEFIELD_WIDTH = this._robot.getBattleFieldWidth() - 8.0;
            double BATTLEFIELD_HEIGHT = this._robot.getBattleFieldHeight() - 8.0;
            double bV = Rules.getBulletSpeed((double)bPower);
            double rX = this._robot.getX();
            double rY = this._robot.getY();
            Point2D.Double rLocation = new Point2D.Double(this._robot.getX(), this._robot.getY());
            double eX = enemy.getX();
            double eY = enemy.getY();
            double eV = enemy.getVelocity();
            double eHdC = Math.toRadians(enemy.getHeadingChange());
            double predictedHd = Math.toRadians(enemy.getHeading());
            deltaTime = 0.0;
            endX = eX;
            endY = eY;
            do {
                double d;
                deltaTime += 1.0;
                if (!(d * bV < rLocation.distance(endX, endY))) break block2;
                endY += Math.cos(predictedHd) * eV;
            } while (!((endX += Math.sin(predictedHd += eHdC) * eV) < 8.0 || endY < 8.0 || endX > BATTLEFIELD_WIDTH) && !(endY > BATTLEFIELD_HEIGHT));
            endX = CircularTargeting.limit(endX, 8.0, BATTLEFIELD_WIDTH);
            endY = CircularTargeting.limit(endY, 8.0, BATTLEFIELD_HEIGHT);
        }
        return new TimestampedLocation((double)this._robot.getTime() + deltaTime, new Point2D.Double(endX, endY));
    }
}

