/*
 * Decompiled with CFR 0.152.
 */
package pedersen.util;

import pedersen.debug.DebuggableBase;
import pedersen.physics.HasWave;
import pedersen.util.CalculatedValue;
import pedersen.util.Conversions;
import pedersen.util.RollingAverage;

public class TargetingStatistics
extends DebuggableBase {
    private long fired = 0L;
    private long hit = 0L;
    private final CalculatedValue average;
    private double energy = 0.0;

    public TargetingStatistics() {
        this.average = new RollingAverage(25.0, 1.0);
    }

    public TargetingStatistics(double d, double w) {
        this.average = new RollingAverage(d, w);
    }

    public void registerHit(HasWave wave) {
        ++this.fired;
        ++this.hit;
        this.average.add(1.0);
        this.energy += this.calcEnergyAdvantage(Conversions.getFirepowerFromBulletVelocity(wave.getWave().getVelocity().velocity()));
    }

    public void registerMiss(HasWave wave) {
        ++this.fired;
        this.average.add(0.0);
        this.energy -= Conversions.getFirepowerFromBulletVelocity(wave.getWave().getVelocity().velocity());
    }

    public double calcEnergyAdvantage(double firepower) {
        return -firepower + Conversions.getBulletDamageFromFirepower(firepower) + Conversions.getEnergyRewardFromFirepower(firepower);
    }

    public double getSuccessRate() {
        return this.average.value();
    }

    public double getTrueSuccessRate() {
        double successRate = 0.0;
        if (this.fired > 0L) {
            successRate = (double)this.hit / (double)this.fired;
        }
        return successRate;
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        if (this.fired > 0L) {
            buffer.append("Success rate: " + super.trim(100.0 * this.getTrueSuccessRate()) + "% of " + this.fired + " shots.").append(" (" + this.trim(this.energy / (double)this.fired) + " advantage per shot)");
        } else {
            buffer.append("No bullets fired.");
        }
        return buffer.toString();
    }

    long getFired() {
        return this.fired;
    }

    long getHit() {
        return this.hit;
    }

    double getEnergy() {
        return this.energy;
    }
}

