/*
 * Decompiled with CFR 0.152.
 */
package az;

import az.displacementVector;
import az.displacementVectorData;
import az.enemyPosition;
import az.treeNode;
import az.util.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Arrays;
import robocode.util.Utils;

public class targetingStatistics {
    String enemyName;
    static double height;
    static double width;
    enemyPosition[] lastPositions = new enemyPosition[128];
    int lastPositions_iter = 0;
    treeNode root;

    targetingStatistics(double _width, double _height, String _enemyName) {
        width = _width;
        height = _height;
        this.enemyName = _enemyName;
        this.root = new treeNode(width, height);
        this.initLastPositions();
    }

    public void add(double time, double x, double y, double heading, double velocity, double enemyCount) {
        if (time == this.lastPositions[this.lastPositions_iter].time) {
            return;
        }
        if (velocity < 0.0) {
            heading = Utils.normalAbsoluteAngle((double)(heading + Math.PI));
            velocity *= -1.0;
        }
        int i = 0;
        while (i < 128) {
            if (time - this.lastPositions[i].time <= 128.0) {
                displacementVectorData data = new displacementVectorData(this.lastPositions[i].x, this.lastPositions[i].y, this.lastPositions[i].heading, x, y);
                data.normalize(width, height);
                this.root.add(new displacementVector(time - this.lastPositions[i].time, data.x, data.y, data.heading, this.lastPositions[i].velocity, this.lastPositions[i].enemyCount, data.xx, data.yy));
                if (data.heading < 0.5235987755982988) {
                    this.root.add(new displacementVector(time - this.lastPositions[i].time, data.x, data.y, Math.PI * 2 + data.heading, this.lastPositions[i].velocity, this.lastPositions[i].enemyCount, data.xx, data.yy));
                }
                if (data.heading > 5.759586531581287) {
                    this.root.add(new displacementVector(time - this.lastPositions[i].time, data.x, data.y, data.heading - Math.PI * 2, this.lastPositions[i].velocity, this.lastPositions[i].enemyCount, data.xx, data.yy));
                }
            }
            ++i;
        }
        this.lastPositions_iter = (this.lastPositions_iter + 1) % 128;
        this.lastPositions[this.lastPositions_iter] = new enemyPosition(time, x, y, heading, velocity, enemyCount);
    }

    public double getBestFiringAngle(double scanTime, double scanX, double scanY, double scanHeading, double scanVelocity, double enemyCount, double ourX, double ourY, double ourHeading, double ourVelocity, double timeNow, double timeAtFire, double bulletSpeed) {
        Object[] events = this.generateProbabilityChangeEventListForFiringAngles(scanTime, scanX, scanY, scanHeading, scanVelocity, enemyCount, ourX, ourY, ourHeading, ourVelocity, timeNow, timeAtFire, bulletSpeed);
        int cnt = 0;
        while (events[cnt] != null) {
            ++cnt;
        }
        Arrays.sort(events, 0, cnt);
        double res = 0.0;
        double bestProbability = -1.0;
        double currentProbability = 0.0;
        int i = 0;
        while (i < cnt) {
            if ((currentProbability += ((Utils.changeEvent)events[i]).delta) > bestProbability) {
                bestProbability = currentProbability;
                res = (((Utils.changeEvent)events[i]).time + ((Utils.changeEvent)events[i + 1]).time) / 2.0;
            }
            ++i;
        }
        return res;
    }

    public Utils.changeEvent[] generateProbabilityChangeEventListForFiringAngles(double scanTime, double scanX, double scanY, double scanHeading, double scanVelocity, double enemyCount, double ourX, double ourY, double ourHeading, double ourVelocity, double timeNow, double timeAtFire, double bulletSpeed) {
        if (scanVelocity < 0.0) {
            scanHeading = Utils.normalAbsoluteAngle((double)(scanHeading + Math.PI));
            scanVelocity *= -1.0;
        }
        displacementVectorData data = new displacementVectorData(scanX, scanY, scanHeading, ourX, ourY);
        int angleNormalizationMode = data.normalize(width, height);
        ourHeading = displacementVectorData.normalizeAngle(ourHeading, angleNormalizationMode);
        return this.root.generateProbabilityChangeEventListForFiringAngles(new displacementVector(data.x, data.y, data.heading, scanVelocity, enemyCount), scanTime, data.x, data.y, data.xx, data.yy, ourHeading, ourVelocity, timeNow, timeAtFire, bulletSpeed, angleNormalizationMode);
    }

    public void initLastPositions() {
        int i = 0;
        while (i < 128) {
            this.lastPositions[i] = new enemyPosition(-129.0);
            ++i;
        }
    }

    public void onPaint(Graphics2D g, double scanTime, double scanX, double scanY, double scanHeading, double scanVelocity, double enemyCount, double ourX, double ourY, double ourHeading, double ourVelocity, double timeNow, double timeAtFire, double bulletSpeed) {
        double angle = this.getBestFiringAngle(scanTime, scanX, scanY, scanHeading, scanVelocity, enemyCount, ourX, ourY, ourHeading, ourVelocity, timeNow, timeAtFire, bulletSpeed);
        g.setColor(Color.red);
        g.drawLine((int)(ourX += ourVelocity * Math.sin(ourHeading) * (timeAtFire - timeNow)), (int)(ourY += ourVelocity * Math.cos(ourHeading) * (timeAtFire - timeNow)), (int)(ourX + 2000.0 * Math.sin(angle)), (int)(ourY + 2000.0 * Math.cos(angle)));
        g.drawOval((int)scanX - 15, (int)scanY - 15, 30, 30);
    }
}

