/*
 * Decompiled with CFR 0.152.
 */
package cb.util;

import cb.ml.Features;
import cb.ml.Movement;
import cb.util.BattleFieldUtils;
import cb.util.MovementState;
import cb.util.Shadow;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.Rules;
import robocode.util.Utils;

public class Wave {
    private static final int BOT_HALF_WIDTH = 18;
    private static final int BOT_WIDTH = 36;
    private ArrayList<Shadow> shadows = new ArrayList();
    private Point2D.Double source = new Point2D.Double();
    private long time;
    private double enemyBulletPower;
    private double bulletVelocity;
    private double angle;
    private double distance;
    private double myLateralVelocity;
    private double myLateralAcceleration;
    private double myAdvancingVelocity;
    private int direction;

    public Wave(MovementState opponentState, double energyLoss, MovementState myOld2State, MovementState myOld3State) {
        this.source.setLocation(opponentState.location);
        this.time = opponentState.time;
        this.enemyBulletPower = energyLoss;
        this.bulletVelocity = Rules.getBulletSpeed((double)energyLoss);
        this.angle = BattleFieldUtils.absoluteBearing(opponentState.location, myOld2State.location);
        this.distance = myOld2State.location.distance(opponentState.location);
        double latVel = myOld2State.velocity * Math.sin(myOld2State.heading - this.angle);
        double latAcc = (myOld2State.velocity - myOld3State.velocity) * Math.sin(myOld2State.heading - this.angle);
        this.direction = latVel >= 0.0 ? 1 : -1;
        this.myLateralVelocity = latVel * (double)this.direction;
        this.myLateralAcceleration = latAcc * (double)this.direction;
        this.myAdvancingVelocity = myOld2State.velocity * Math.cos(myOld2State.heading - this.angle);
    }

    public Point2D.Double getSource() {
        return this.source;
    }

    public long getTime() {
        return this.time;
    }

    public double getEnemyBulletPower() {
        return this.enemyBulletPower;
    }

    public double getAngle(double guessFactor) {
        return this.angle + (double)this.direction * guessFactor * BattleFieldUtils.maximumEscapeAngle(this.enemyBulletPower);
    }

    public double getAngle() {
        return this.getAngle(0.0);
    }

    public double getGuessFactor(Point2D.Double point) {
        double a = BattleFieldUtils.absoluteBearing(this.source, point);
        return (double)this.direction * Utils.normalRelativeAngle((double)(a - this.angle)) / BattleFieldUtils.maximumEscapeAngle(this.enemyBulletPower);
    }

    public double getDanger(Point2D.Double point, Movement movement) {
        double minGF = Double.POSITIVE_INFINITY;
        double maxGF = Double.NEGATIVE_INFINITY;
        for (int x = -18; x <= 18; x += 36) {
            for (int y = -18; y <= 18; y += 36) {
                double gf = this.getGuessFactor(new Point2D.Double(point.x + (double)x, point.y + (double)y));
                minGF = Math.min(gf, minGF);
                maxGF = Math.max(gf, maxGF);
            }
        }
        return movement.getProbability(this.getFeatures(), minGF, maxGF);
    }

    public double getTimeUntilHit(Point2D.Double point, long time) {
        return this.source.distance(point) / this.bulletVelocity - (double)time + (double)this.time;
    }

    public double getDistanceTraveled(long time) {
        return (double)(time - this.time) * this.bulletVelocity;
    }

    public void addShadow(Point2D.Double p1, Point2D.Double p2) {
        double gf1 = this.getGuessFactor(p1);
        double gf2 = this.getGuessFactor(p2);
        this.shadows.add(new Shadow(gf1, gf2));
    }

    public Features getFeatures() {
        Features features = new Features();
        features.setFeature("myLateralVelocity", this.myLateralVelocity);
        features.setFeature("myLateralAcceleration", this.myLateralAcceleration);
        features.setFeature("myAdvancingVelocity", this.myAdvancingVelocity);
        features.setFeature("distance", this.distance);
        features.setFeature("enemyBulletPower", this.enemyBulletPower);
        return features;
    }

    public ArrayList<Shadow> getShadows() {
        return this.shadows;
    }

    public boolean hasPassed(Point2D.Double location, long time) {
        double timeUntilPass = (location.distance(this.source) + 18.0 - (double)(time - this.time) * this.bulletVelocity) / this.bulletVelocity;
        return timeUntilPass < 0.0;
    }
}

