/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import pa3k.Aiming;
import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.Position;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Opponent {
    protected String name;
    protected double[] lastHeading;
    protected double[] lastVelocity;
    protected Position[] lastPosition;
    protected long[] lastTime;
    protected int lastIndex;
    public static final int HISTORY = 40;
    protected int lastEnergyIndex;
    protected double lastEnergy;
    protected double[] lastEnergyDrop;
    protected long[] lastEnergyDropTime;
    protected Aiming selfAiming;
    protected Aiming opponentAiming;
    protected double solicitedEnergyLost;
    protected boolean dead;
    protected int lastDirection;

    public void giveSolicitedEnergyLost(double e) {
        this.solicitedEnergyLost += e;
    }

    public Opponent(String name, AdvancedRobot robot, Aiming selfAiming, Aiming opponentAiming) {
        this.name = name;
        this.lastIndex = 0;
        this.lastEnergyIndex = 0;
        this.lastHeading = new double[40];
        this.lastVelocity = new double[40];
        this.lastPosition = new Position[40];
        this.lastTime = new long[40];
        this.lastEnergy = 100.0;
        this.lastEnergyDrop = new double[40];
        this.lastEnergyDropTime = new long[40];
        int i = 0;
        while (i < this.lastPosition.length) {
            this.lastPosition[i] = new Position();
            ++i;
        }
        this.lastTime[0] = 0L;
        this.solicitedEnergyLost = 0.0;
        this.selfAiming = selfAiming;
        this.opponentAiming = opponentAiming;
        this.lastDirection = 1;
        this.dead = false;
    }

    public int getScanPriority(long time) {
        if (this.dead) {
            return -1;
        }
        int d = (int)(time - this.getLastTime());
        if (d > 14) {
            this.dead = true;
            return -1;
        }
        return d;
    }

    public void bulletHit(BulletTracking b) {
        if (b.getTargetOpponent() == this) {
            this.selfAiming.hit(b);
        } else {
            this.selfAiming.possibleHit(b);
        }
        this.solicitedEnergyLost += b.getDamage();
    }

    public void bulletPossibleHit(BulletTracking b) {
        assert (b.getTargetOpponent() == this);
        this.selfAiming.possibleHit(b);
    }

    public void bulletMiss(BulletTracking b) {
        this.selfAiming.miss(b);
    }

    public long lastSeen(long time) {
        return time - this.lastTime[this.lastIndex];
    }

    public BulletTracking updateInfo(ScannedRobotEvent e, double bearing, Position p) {
        long timeDelta = e.getTime() - this.lastTime[this.lastIndex];
        if (timeDelta > 1L) {
            Log.log(3, String.valueOf(e.getTime()) + ": " + (timeDelta - 1L) + " scan(s) skipped");
        }
        ++this.lastIndex;
        this.lastIndex %= 40;
        this.lastHeading[this.lastIndex] = e.getHeadingRadians();
        this.lastVelocity[this.lastIndex] = e.getVelocity();
        if (this.lastVelocity[this.lastIndex] > 0.0) {
            this.lastDirection = 1;
        }
        if (this.lastVelocity[this.lastIndex] < 0.0) {
            this.lastDirection = -1;
        }
        this.lastTime[this.lastIndex] = e.getTime();
        this.lastPosition[this.lastIndex].x = p.x + Math.sin(bearing) * e.getDistance();
        this.lastPosition[this.lastIndex].y = p.y + Math.cos(bearing) * e.getDistance();
        this.lastPosition[this.lastIndex].correctForWalls();
        if (e.getEnergy() + this.solicitedEnergyLost < this.lastEnergy && timeDelta == 1L) {
            ++this.lastEnergyIndex;
            this.lastEnergyIndex %= 40;
            this.lastEnergyDrop[this.lastEnergyIndex] = this.lastEnergy - e.getEnergy() + this.solicitedEnergyLost;
            this.lastEnergyDropTime[this.lastEnergyIndex] = e.getTime();
            if (this.lastEnergyDrop[this.lastEnergyIndex] >= 0.09000000000000001 && this.lastEnergyDrop[this.lastEnergyIndex] <= 3.01) {
                this.lastEnergy = e.getEnergy();
                this.solicitedEnergyLost = 0.0;
                return new BulletTracking(this.lastEnergyDrop[this.lastEnergyIndex], e.getTime() - 1L);
            }
        }
        this.solicitedEnergyLost = 0.0;
        this.lastEnergy = e.getEnergy();
        return null;
    }

    public Position getLastPosition(long time) throws Exception {
        int last = this.lastIndex;
        int i = 0;
        while (i < 40) {
            if (this.lastTime[last] == time) {
                return this.lastPosition[last];
            }
            if (this.lastTime[last] < time) {
                if (i > 0) {
                    return this.lastPosition[last].getAverage(this.lastPosition[(last + 1) % 40]);
                }
                Position estimate = new Position(this.lastPosition[last]);
                estimate.modify(time - this.lastTime[last], this.lastVelocity[last], this.lastHeading[last]);
                return estimate;
            }
            last += 39;
            last %= 40;
            ++i;
        }
        throw new Exception();
    }

    public double getLastHeading(long time) throws Exception {
        int last = this.lastIndex;
        int i = 0;
        while (i < 40) {
            if (this.lastTime[last] == time) {
                return this.lastHeading[last];
            }
            if (this.lastTime[last] < time) {
                if (i > 0) {
                    return Utils.normalAbsoluteAngle((double)((Utils.normalRelativeAngle((double)this.lastHeading[last]) + Utils.normalRelativeAngle((double)this.lastHeading[(last + 1) % 40])) / 2.0));
                }
                int idxBefore = (last + 40 - 1) % 40;
                return Utils.normalAbsoluteAngle((double)(this.lastHeading[last] + Utils.normalRelativeAngle((double)(this.lastHeading[last] - this.lastHeading[idxBefore])) * (double)(time - this.lastTime[idxBefore]) / (double)(this.lastTime[last] - this.lastTime[idxBefore])));
            }
            last += 39;
            last %= 40;
            ++i;
        }
        throw new Exception();
    }

    public double getLastVelocity(long time) throws Exception {
        int last = this.lastIndex;
        int i = 0;
        while (i < 40) {
            if (this.lastTime[last] == time) {
                return this.lastVelocity[last];
            }
            if (this.lastTime[last] < time) {
                if (i > 0) {
                    return (this.lastVelocity[last] + this.lastVelocity[(last + 1) % 40]) / 2.0;
                }
                int idxBefore = (last + 40 - 1) % 40;
                return this.lastVelocity[last] + (this.lastVelocity[last] - this.lastVelocity[idxBefore]) * (double)(time - this.lastTime[idxBefore]) / (double)(this.lastTime[last] - this.lastTime[idxBefore]);
            }
            last += 39;
            last %= 40;
            ++i;
        }
        throw new Exception();
    }

    public void bulletMissedMe(BulletTracking b) {
        if (this.opponentAiming != null) {
            this.opponentAiming.miss(b);
        }
    }

    public void bulletHitMe(BulletTracking b) {
        if (this.opponentAiming != null) {
            this.opponentAiming.hit(b);
        }
    }

    public void death() {
        this.dead = true;
        Log.log(1, "Opponent " + this + " died");
        Log.log(1, "Opponents aming:");
        if (this.opponentAiming != null) {
            this.opponentAiming.dumpStats();
        }
        Log.log(1, "Our aming at opponent:");
        this.selfAiming.dumpStats();
    }

    public double getMaxVelocity() {
        if (this.lastEnergy == 0.0) {
            return 0.01;
        }
        return 8.0;
    }

    public Aiming getSelfAiming() {
        return this.selfAiming;
    }

    public Aiming getOpponentAiming() {
        return this.opponentAiming;
    }

    public long getLastTime() {
        return this.lastTime[this.lastIndex];
    }

    public Position getLastPosition() {
        return this.lastPosition[this.lastIndex];
    }

    public double getLastEnergy() {
        return this.lastEnergy;
    }

    public double getLastHeading() {
        return this.lastHeading[this.lastIndex];
    }

    public double getLastVelocity() {
        return this.lastVelocity[this.lastIndex];
    }

    public String toString() {
        return this.name;
    }

    public void bulletPossibleHitMe(BulletTracking possibleHit) {
        if (this.opponentAiming != null) {
            this.opponentAiming.possibleHit(possibleHit);
        }
    }

    public Position projectPosition(Position bulletSource, double bulletVelocity, long currentTime, int timeOffset) {
        Position r = new Position(this.getLastPosition());
        double origVelocity = 0.0;
        double heading = 0.0;
        double dHeading = 0.0;
        try {
            origVelocity = this.getLastVelocity(currentTime);
            heading = this.getLastHeading(currentTime);
            dHeading = this.getLastHeading(currentTime) - this.getLastHeading(currentTime - 1L);
        }
        catch (Exception e) {
            Thread.dumpStack();
            return r;
        }
        double velocity = origVelocity;
        int i = 0;
        while ((double)i < bulletSource.distance(r) / bulletVelocity - 1.0 - (double)timeOffset) {
            if (velocity != 0.0) {
                Position prev = new Position(r);
                r.modify(1L, velocity, heading);
                r.adjustForWalls(prev, 1, null, 0.0, velocity < 0.0 ? Utils.normalAbsoluteAngle((double)(heading + Math.PI)) : heading);
                r.check();
            }
            Log.paintPoint(3, r, Color.WHITE);
            double maxTurnRate = Math.abs(Rules.getTurnRateRadians((double)Math.abs(velocity)));
            if (dHeading > maxTurnRate) {
                dHeading = maxTurnRate;
            }
            if (dHeading < -maxTurnRate) {
                dHeading = -maxTurnRate;
            }
            heading = Utils.normalAbsoluteAngle((double)(heading + dHeading));
            ++i;
        }
        return r;
    }

    private int getLastDirection() {
        return this.lastDirection;
    }

    public double getVelocityDelta() {
        long t = this.getLastTime();
        try {
            return this.getLastVelocity(t) - this.getLastVelocity(t - 1L);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public long getLastSpeedChange(long now) {
        long t = now;
        try {
            double speed = this.getLastVelocity(now);
            int i = 0;
            while (i < 40) {
                if (speed != this.getLastVelocity(--t)) {
                    return now - t;
                }
                ++i;
            }
        }
        catch (Exception e) {
            return 10000L;
        }
        return 10000L;
    }

    public long getLastEnergyDrop(long now) {
        if (this.lastEnergyDropTime[this.lastEnergyIndex] == 0L) {
            return Long.MAX_VALUE;
        }
        return now - this.lastEnergyDropTime[this.lastEnergyIndex];
    }
}

