/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;

public class ColorX
extends Color {
    private static final long serialVersionUID = 5119489392438941187L;

    public ColorX(float[] components) {
        super(components[0], components[1], components[2], components[3]);
    }

    public ColorX(Color color) {
        this(ColorX.getComponents(color));
    }

    private ColorX(int color) {
        super(color);
    }

    public static ColorX withOpacity(Color color, float opacity) {
        return new ColorX(color).withOpacity(opacity);
    }

    public ColorX atLevel(Level level) {
        return this.withOpacity(this.getLevelOpacity(level));
    }

    public ColorX withOpacity(float opacity) {
        float[] components = ColorX.getComponents(this);
        components[3] = opacity;
        return new ColorX(components);
    }

    public ColorX withSaturation(float saturation) {
        float[] components = new float[3];
        Color.RGBtoHSB(this.getRed(), this.getGreen(), this.getBlue(), components);
        int color = Color.HSBtoRGB(components[0], saturation, components[2]);
        return new ColorX(color);
    }

    public static ColorX blend(Color color1, Color color2) {
        return new ColorX(color1).blend(color2);
    }

    public ColorX blend(Color color) {
        float[] otherComponents;
        float[] components = ColorX.getComponents(this);
        float total = components[3] + (otherComponents = ColorX.getComponents(color))[3];
        float ratio = total == 0.0f ? 0.0f : components[3] / total;
        float otherRatio = total == 0.0f ? 0.0f : otherComponents[3] / total;
        components[0] = components[0] * ratio + otherComponents[0] * otherRatio;
        components[1] = components[1] * ratio + otherComponents[1] * otherRatio;
        components[2] = components[2] * ratio + otherComponents[2] * otherRatio;
        components[3] = (components[3] + otherComponents[3]) / 2.0f;
        return new ColorX(components);
    }

    private static float[] getComponents(Color color) {
        float[] components = new float[4];
        color.getRGBComponents(components);
        return components;
    }

    private float getLevelOpacity(Level level) {
        switch (level) {
            case Crucial: {
                return 1.0f;
            }
            case Important: {
                return 0.75f;
            }
            case Informational: {
                return 0.5f;
            }
            case Fluff: {
                return 0.33f;
            }
        }
        return 0.1f;
    }

    public static ColorX GetRobotColor(String name) {
        int rollover = (5 * name.hashCode() - 250) % 360;
        rollover = rollover > 0 ? rollover : rollover + 360;
        return new ColorX(new Color(Color.HSBtoRGB((float)rollover / 360.0f, 1.0f, 0.66f)));
    }

    public static enum Level {
        Crucial,
        Important,
        Informational,
        Fluff;

    }
}

