/*
 * Decompiled with CFR 0.152.
 */
package kid.targeting;

import java.awt.Color;
import java.io.PrintStream;
import kid.graphics.Colors;
import kid.robot.RobotData;
import kid.targeting.Targeting;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;

public class CircularTargeting
extends Targeting {
    private static final long serialVersionUID = 6581499402431094042L;
    private boolean avgHeading = false;
    private boolean avgVelocity = false;

    public CircularTargeting(Robot myRobot) {
        this(myRobot, false, false);
    }

    public CircularTargeting(Robot myRobot, boolean avgVelocity, boolean avgHeading) {
        super(myRobot);
        this.init(avgHeading, avgVelocity);
    }

    public CircularTargeting(CircularTargeting targeting) {
        super(targeting);
        this.init(targeting.avgVelocity, targeting.avgHeading);
    }

    private void init(boolean avgVelocity, boolean avgHeading) {
        this.avgHeading = avgHeading;
        this.avgVelocity = avgVelocity;
    }

    @Override
    public double getAngle(RobotData target, double firePower) {
        return super.getAngle(target, firePower, this.avgVelocity ? target.getAvgVelocity() : target.getVelocity(), this.avgHeading ? target.getAvgDeltaHeading() : target.getDeltaHeading());
    }

    @Override
    public Color getColor() {
        return Colors.BLUE;
    }

    @Override
    public String getName() {
        return new String("Circular Targeting");
    }

    @Override
    public String getType() {
        return new String("Fast");
    }

    @Override
    public void print(PrintStream console) {
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }

    public void debug(PrintStream console) {
    }

    public void debug(RobocodeFileOutputStream output) {
    }

    public Object clone() {
        return new CircularTargeting(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CircularTargeting) {
            CircularTargeting targeting = (CircularTargeting)obj;
            if (targeting.robot != null && targeting.robot.getName() != null && this.robot != null) {
                return targeting.robot.getName().equals(this.robot.getName());
            }
        }
        return false;
    }

    public String toString() {
        return new String();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }
}

