/*
 * Decompiled with CFR 0.152.
 */
package agrach;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.TurnCompleteCondition;
import robocode.util.Utils;

public class Dalek
extends AdvancedRobot {
    private static final boolean DBG = false;
    private static final boolean GUN_DBG = false;
    private static final boolean TURS_DBG = false;
    private static final boolean SHOT = true;
    protected final int FIRE_CONSTANT = 550;
    protected final int MANTINEL = 50;
    protected ScannedRobotEvent target = null;
    protected ScannedRobotEvent old = null;
    protected double shotTreshold = 0.1;
    protected int shotCount = 0;
    protected double hitTreshold = 2.0;
    protected int hitCount = 0;
    protected int changeDirByHit = 1;
    protected double firePower;
    protected int moveDir = 1;
    protected boolean nearWall = false;
    protected double tankAhead;
    protected double tankTurn;
    protected double gunTurn;
    protected double radarTurn;

    public void run() {
        this.setScanColor(Color.red);
        this.setBulletColor(Color.yellow);
        this.setBodyColor(new Color(14523932));
        this.setRadarColor(new Color(14523932));
        this.setGunColor(new Color(5851693));
        this.setTurnRadarLeft(360.0);
        while (true) {
            if (this.target != null && this.getTime() > this.target.getTime() + 3L) {
                this.target = null;
                this.setTurnRadarRight(360.0);
            } else if (this.target == null) {
                this.setTurnRadarRight(360.0);
            }
            this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.old = this.target;
        this.target = e;
        this.nearWall();
        this.tankAhead = 100.0;
        double maxTankTurn = 10.0 - 0.75 * Math.abs(this.getVelocity());
        if (this.nearWall) {
            this.tankTurn = e.getBearing() - 15.0 + Math.random() * 25.0;
            this.moveDir = 1;
        } else {
            if (this.old != null && Math.abs(this.target.getEnergy() - this.old.getEnergy()) >= this.shotTreshold && this.shotCount % this.changeDirByHit == 0) {
                this.moveDir *= -1;
                ++this.shotCount;
            }
            if (this.old != null) {
                this.out.println("SHOT DETECTION - " + this.getTime());
                this.out.println("oldEnergy  : " + this.old.getEnergy());
                this.out.println("newEnergy  : " + this.target.getEnergy());
                this.out.println("shotsCount : " + this.shotCount);
                this.out.println("hitsCount  : " + this.hitCount);
                this.out.println("shotTresh  : " + this.shotTreshold);
                this.out.println("changeDir  : " + this.changeDirByHit);
                this.out.println("direction  : " + this.moveDir);
            }
            if (this.getTime() % 9L == 0L) {
                this.tankAhead = 5.0;
            }
            this.tankTurn = e.getBearing() + 90.0 - 15.0 + Math.random() * 25.0;
        }
        if (this.tankTurn > maxTankTurn) {
            this.tankTurn = maxTankTurn;
        } else if (this.tankTurn < -maxTankTurn) {
            this.tankTurn = -maxTankTurn;
        }
        this.gunTurn = this.getGunRelativeHeading();
        this.gunTurn -= Utils.normalRelativeAngleDegrees((double)(this.getGunHeading() - this.getHeading()));
        this.gunTurn -= this.tankTurn;
        this.gunTurn = this.optimizeTurn(this.gunTurn);
        this.radarTurn = this.getHeading() - this.getRadarHeading() + e.getBearing();
        this.radarTurn = Math.abs(this.gunTurn) < 20.0 ? (this.radarTurn -= this.gunTurn) : (this.gunTurn > 0.0 ? (this.radarTurn -= 20.0) : (this.radarTurn += 20.0));
        this.radarTurn -= this.tankTurn;
        this.radarTurn = this.optimizeTurn(this.radarTurn);
        this.setTurnRight(this.tankTurn);
        this.setTurnGunRight(this.gunTurn);
        this.setTurnRadarRight(this.radarTurn);
        this.setAhead(this.tankAhead * (double)this.moveDir);
        this.setFire(this.firePower);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        ++this.hitCount;
        if ((double)(this.shotCount / this.hitCount) > this.hitTreshold) {
            this.changeDirByHit %= 2;
            ++this.changeDirByHit;
            this.hitTreshold -= 0.1;
            this.shotCount = 0;
            this.hitCount = 0;
        }
        this.shotTreshold = event.getPower() * 0.1;
    }

    protected double getGunRelativeHeading() {
        double relHeading;
        double bearing = this.target.getBearing();
        double velocity = this.target.getVelocity();
        double heading = this.target.getHeading();
        this.firePower = Math.min(550.0 / this.target.getDistance(), 3.0);
        double bulletSpeed = 20.0 - this.firePower * 3.0;
        double gama = 180.0 - (heading - (this.getHeading() + bearing) % 180.0);
        gama = Math.toRadians(Math.abs(gama) % 180.0);
        double gunHeading = Math.abs(Math.toDegrees(Math.asin(velocity / bulletSpeed * Math.sin(gama))));
        double absBearing = this.getHeading() + bearing;
        if (absBearing > 180.0) {
            absBearing -= 360.0;
        }
        if ((relHeading = heading - absBearing) > 180.0) {
            relHeading -= 360.0;
        }
        gunHeading = relHeading * velocity >= 0.0 ? bearing + gunHeading : bearing - gunHeading;
        return gunHeading;
    }

    protected double optimizeTurn(double turn) {
        if (turn > 180.0) {
            turn -= 360.0;
        } else if (turn < -180.0) {
            turn += 360.0;
        }
        return turn;
    }

    protected void nearWall() {
        this.nearWall = this.getX() < 50.0 || this.getY() < 50.0 || this.getX() > this.getBattleFieldWidth() - 50.0 || this.getY() > this.getBattleFieldHeight() - 50.0;
    }
}

