/*
 * Decompiled with CFR 0.152.
 */
package gjr;

import java.awt.geom.Point2D;

public class RobocodeUtils {
    public static Point2D.Double calculatePosition(double absoluteBearing, double distance, Point2D.Double myPosition) {
        double enemyX = Math.sin(absoluteBearing) * distance + myPosition.getX();
        double enemyY = Math.cos(absoluteBearing) * distance + myPosition.getY();
        return new Point2D.Double(enemyX, enemyY);
    }

    public static double calculateBulletDamage(double power) {
        return 4.0 * power + 2.0 * (power > 1.0 ? power - 1.0 : 0.0);
    }

    public static double normaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public static double absBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Point2D.Double.distance(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }
}

