/*
 * Decompiled with CFR 0.152.
 */
package agd.predict;

import agd.predict.Footprint;
import agd.util.Coord;
import java.util.Comparator;
import java.util.List;

public interface Trackable {
    public List getRecentFootprints();

    public static class DistanceComparator
    implements Comparator {
        private Coord referencePoint;

        public DistanceComparator(Coord point) {
            this.referencePoint = point;
        }

        public int compare(Object o1, Object o2) {
            int comparison = 0;
            Trackable t1 = (Trackable)o1;
            Trackable t2 = (Trackable)o2;
            List footprints1 = t1.getRecentFootprints();
            List footprints2 = t2.getRecentFootprints();
            if (footprints1.size() > 0 && footprints2.size() > 0) {
                Footprint fp1 = (Footprint)footprints1.get(footprints1.size() - 1);
                Footprint fp2 = (Footprint)footprints2.get(footprints2.size() - 1);
                comparison = (int)(fp1.getPosition().distanceTo(this.referencePoint) - fp2.getPosition().distanceTo(this.referencePoint));
            }
            return comparison;
        }
    }
}

