/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy;

import alk.lap.LoudAndProud;
import alk.lap.strategy.FireWave;
import alk.lap.strategy.ScanDatabase;
import alk.lap.strategy.targetting.BulletBeam;
import alk.lap.utils.DVektor;

public class StatisticWave
extends FireWave {
    public DVektor emittingPosition;
    public DVektor proudsPositionAtEmission;
    public String label;
    public double power;
    public double bulletVelocity;
    public int maxAge;
    private LoudAndProud proud;
    private static String names = "ABCDEFGHIKL";
    private static int currentName = 0;
    private long emittingTime;
    private BulletBeam[] nullBeam = new BulletBeam[0];

    public StatisticWave(double power, LoudAndProud proud) {
        this.proud = proud;
        this.power = power;
        this.emittingPosition = proud.getTacticLead().getEnemyPos().copy();
        this.label = "(" + names.substring(currentName, currentName + 1) + ")";
        currentName = (currentName + 1) % 10;
        ScanDatabase scanbase = proud.getStrategicLead().getAnalystsDB().getScanBase();
        this.proudsPositionAtEmission = scanbase.getLastProudState().pos;
        this.emittingTime = scanbase.getLastProudState().getScanTime();
        double fieldWidth = proud.getBattleFieldWidth();
        double fieldHeight = proud.getBattleFieldHeight();
        double mostDistX = 0.0;
        double mostDistY = 0.0;
        if (this.emittingPosition.x < fieldWidth / 2.0) {
            mostDistX = fieldWidth;
        }
        if (this.emittingPosition.y < fieldHeight / 2.0) {
            mostDistY = fieldHeight;
        }
        this.bulletVelocity = 20.0 - 3.0 * power;
        this.maxAge = (int)Math.round(DVektor.sub(this.emittingPosition, new DVektor(mostDistX, mostDistY)).getLength() / this.bulletVelocity);
    }

    public void increment() {
    }

    private long getAge() {
        return this.proud.getTime() - this.emittingTime;
    }

    public double getCurrentRadius() {
        return this.bulletVelocity * (double)this.getAge();
    }

    public boolean isValid() {
        boolean proudIsPassed;
        double distanceToProud = DVektor.sub(this.emittingPosition, this.proud.getPosition()).getLength() + this.proud.getProudsRadius();
        boolean bl = proudIsPassed = this.getCurrentRadius() > distanceToProud;
        if (proudIsPassed) {
            double deltaToEmission = this.emittingPosition.getDirectionTo(this.proud.getPosition()) - this.emittingPosition.getDirectionTo(this.proudsPositionAtEmission);
            this.proud.getStrategicLead().getAnalystsDB().incrementContProudHitAngleAtBearing(deltaToEmission);
        }
        return this.getAge() < (long)this.maxAge && !proudIsPassed;
    }

    public BulletBeam[] getPossibleBulletVelocities() {
        return this.nullBeam;
    }
}

