/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.EnemyPrediction;

import java.util.ArrayList;
import rdt.Wraith.Configuration;
import rdt.Wraith.EnemyPrediction.BulletPrediction;
import rdt.Wraith.EnemyPrediction.IEnemyPredictionEventHandler;
import rdt.Wraith.EnemyPrediction.IEnemyPredictionManager;
import rdt.Wraith.EnemyPrediction.PredictedPosition;
import rdt.Wraith.IRobot;
import rdt.Wraith.IRoundStartedEventHandler;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Targeting.ITargeting;
import rdt.Wraith.Targeting.Target;
import rdt.Wraith.Utils.MathUtils;
import rdt.Wraith.Utils.RuleUtils;
import rdt.Wraith.Waves.IWaveEventHandler;
import rdt.Wraith.Waves.IWaveManager;
import rdt.Wraith.Waves.WaveData;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;

public class EnemyPredictionManager
implements IEnemyPredictionManager,
IRoundStartedEventHandler,
IWaveEventHandler {
    private BulletPrediction[] _bulletPredictions;
    private int _bulletPredictionCount;
    private int _waveBulletPredictionsCount;
    private IWaveManager _enemyWaveManager;
    private IRobot _robot;
    private ITargeting _targeting;
    private double[] _bulletAngles;
    private long _lastPredictionTick;
    private final int _noBulletPredictionUpdateRate;
    private boolean _resetPrediction = true;
    private final double _battlefieldWidth;
    private final double _battlefieldHeight;
    private ArrayList<IEnemyPredictionEventHandler> _registeredEventHandlers = new ArrayList();

    public EnemyPredictionManager(IRobot robot, ITargeting targeting, IWaveManager enemyWaveManager) {
        int maxPredictedBullets = 50;
        this._noBulletPredictionUpdateRate = 5;
        this._bulletAngles = new double[Math.max(3, 3)];
        this._enemyWaveManager = enemyWaveManager;
        this._robot = robot;
        this._targeting = targeting;
        this._battlefieldWidth = this._robot.getBattleFieldWidth();
        this._battlefieldHeight = this._robot.getBattleFieldHeight();
        double slowestBullet = RuleUtils.GetBulletVelocity(3.0);
        double largestDistance = Math.sqrt(robot.getBattleFieldWidth() * robot.getBattleFieldWidth() + robot.getBattleFieldHeight() * robot.getBattleFieldWidth());
        int maxBulletFlightTime = (int)Math.ceil(largestDistance / slowestBullet);
        this._bulletPredictions = new BulletPrediction[maxPredictedBullets];
        for (int bulletIndex = 0; bulletIndex < this._bulletPredictions.length; ++bulletIndex) {
            this._bulletPredictions[bulletIndex] = new BulletPrediction(256);
        }
        this._robot.RegisterForEventHandling(this);
        this._enemyWaveManager.RegisterWaveEventHandler(this);
        this._lastPredictionTick = Long.MIN_VALUE;
    }

    public void Update() {
        this.CheckForNonBulletResets();
        if (this._resetPrediction) {
            this.GenerateBulletPredictions();
            this.GenerateFutureBullets();
            this._resetPrediction = false;
            this._lastPredictionTick = this._robot.getTime();
        }
        for (int bulletPrediction = 0; bulletPrediction < this._bulletPredictionCount; ++bulletPrediction) {
            this._bulletPredictions[bulletPrediction].UpdateInterceptTimes(this._robot);
        }
    }

    private void CheckForNonBulletResets() {
        if (this._resetPrediction) {
            return;
        }
        long currentTick = this._robot.getTime();
        if (this._enemyWaveManager.GetActiveWaves().size() <= 0 && this._lastPredictionTick + (long)this._noBulletPredictionUpdateRate <= currentTick) {
            this._resetPrediction = true;
            return;
        }
    }

    private void GenerateBulletPredictions() {
        this._bulletPredictionCount = 0;
        this._waveBulletPredictionsCount = 0;
        this.GenerateFromExistingEnemyWaves();
        for (int index = 0; index < this._registeredEventHandlers.size(); ++index) {
            this._registeredEventHandlers.get(index).OnEnemyBulletPredictionChangedEvent();
        }
    }

    @Override
    public BulletPrediction[] GetBulletPredictions() {
        return this._bulletPredictions;
    }

    @Override
    public int GetBulletPredictionCount() {
        return this._bulletPredictionCount;
    }

    @Override
    public void RegisterForEventHandling(IEnemyPredictionEventHandler eventHandler) {
        this._registeredEventHandlers.add(eventHandler);
    }

    @Override
    public void OnRoundStartedEvent() {
        this._resetPrediction = true;
        this._bulletPredictionCount = 0;
        this._waveBulletPredictionsCount = 0;
        this._lastPredictionTick = Long.MIN_VALUE;
    }

    @Override
    public void OnWaveGeneratedEvent() {
        this._resetPrediction = true;
    }

    @Override
    public void OnBulletHitBulletWithWaveEvent(BulletHitBulletEvent eventData, WaveData waveData) {
    }

    @Override
    public void OnHitByBulletWithWaveEvent(HitByBulletEvent eventData, WaveData waveData) {
    }

    @Override
    public void OnWavePassed(WaveData waveData, Target target) {
    }

    private void GenerateFromExistingEnemyWaves() {
        ArrayList<WaveData> activeWaves = this._enemyWaveManager.GetActiveWaves();
        int waveCount = activeWaves.size();
        for (int index = 0; index < waveCount; ++index) {
            WaveData wave = activeWaves.get(index);
            this.GenerateWavePrediction(wave);
        }
    }

    private void GenerateWavePrediction(WaveData waveData) {
        double firepower = waveData.Firepower;
        RobotSnapshot targetWhenCalculatedGunFiring = waveData.TargetThatFired.RobotSnapshots.Read(waveData.ActivationTick - 1L);
        int predictedAngleCount = waveData.TargetThatFired.GunsFiredFromTarget.PredictAngles(targetWhenCalculatedGunFiring.LocationX, targetWhenCalculatedGunFiring.LocationY, waveData.ActivationTick, Rules.getBulletSpeed((double)firepower), 3, this._bulletAngles);
        long currentTick = this._robot.getTime();
        long ticksLeftToWaveDeactivation = waveData.TickWaveIsOutsideBattlefield - currentTick;
        long predictionLength = Math.min(ticksLeftToWaveDeactivation, 140L);
        block0: for (int angleIndex = 0; angleIndex < predictedAngleCount; ++angleIndex) {
            double predictedAngle = this._bulletAngles[angleIndex];
            double dX = MathUtils.FastSin(predictedAngle);
            double dY = MathUtils.FastCos(predictedAngle);
            BulletPrediction prediction = this._bulletPredictions[this._bulletPredictionCount];
            ++this._bulletPredictionCount;
            prediction.TickPredictionWasGenerated = currentTick;
            prediction.FiringTick = waveData.ActivationTick;
            prediction.PredictionDeactivationTime = currentTick + predictionLength;
            prediction.Firepower = firepower;
            prediction.DamageDealt = Rules.getBulletDamage((double)prediction.Firepower);
            prediction.FuturePrediction = false;
            prediction.Weight = Configuration.BulletPredictionWeights[angleIndex];
            long predictionTick = currentTick;
            while (predictionTick < prediction.PredictionDeactivationTime) {
                PredictedPosition predictedPosition = prediction.Write(predictionTick);
                double waveDistance = waveData.GetDistanceForTick(predictionTick);
                double x = waveData.OriginX + waveDistance * dX;
                double y = waveData.OriginY + waveDistance * dY;
                predictedPosition.X = x;
                predictedPosition.Y = y;
                predictedPosition.Tick = predictionTick++;
                if (!(x <= 0.0 || x >= this._battlefieldWidth || y <= 0.0) && !(y >= this._battlefieldHeight)) continue;
                prediction.PredictionDeactivationTime = predictionTick;
                continue block0;
            }
        }
        this._waveBulletPredictionsCount = this._bulletPredictionCount;
    }

    private void GenerateFutureBullets() {
        this._bulletPredictionCount = this._waveBulletPredictionsCount;
        ArrayList<Target> targets = this._targeting.GetTargets();
        for (int targetIndex = 0; targetIndex < targets.size(); ++targetIndex) {
            Target target = targets.get(targetIndex);
            if (!target.Valid || !target.Alive) continue;
            this.GenerateFutureBulletsForTarget(target);
        }
    }

    private void GenerateFutureBulletsForTarget(Target target) {
        long thisTick = this._robot.getTime();
        long firingTick = target.NextTickCanFireAgain;
        if (firingTick > this._robot.GetSafePredictedTick(firingTick)) {
            return;
        }
        firingTick = target.GetSafePredictedTick(firingTick);
        RobotSnapshot predictedFiringPosition = target.RobotSnapshots.Read(firingTick);
        double targetFirepower = target.LastFiredBulletFirepower <= 0.0 ? 1.7 : target.LastFiredBulletFirepower;
        double predictedFirepower = Math.min(predictedFiringPosition.Energy, targetFirepower);
        double predictedBulletVelocity = RuleUtils.GetBulletVelocity(predictedFirepower);
        int predictedAngleCount = target.GunsFiredFromTarget.PredictAngles(predictedFiringPosition.LocationX, predictedFiringPosition.LocationY, firingTick, predictedBulletVelocity, 3, this._bulletAngles);
        block0: for (int angleIndex = 0; angleIndex < predictedAngleCount; ++angleIndex) {
            double predictedAngle = this._bulletAngles[angleIndex];
            double dX = MathUtils.FastSin(predictedAngle);
            double dY = MathUtils.FastCos(predictedAngle);
            BulletPrediction prediction = this._bulletPredictions[this._bulletPredictionCount];
            ++this._bulletPredictionCount;
            prediction.TickPredictionWasGenerated = thisTick;
            prediction.FiringTick = firingTick;
            prediction.PredictionDeactivationTime = firingTick + 140L;
            prediction.Firepower = predictedFirepower;
            prediction.DamageDealt = Rules.getBulletDamage((double)prediction.Firepower);
            prediction.FuturePrediction = true;
            prediction.Weight = Configuration.BulletPredictionWeights[angleIndex];
            double x = predictedFiringPosition.LocationX;
            double y = predictedFiringPosition.LocationY;
            long predictionTick = firingTick;
            while (predictionTick < prediction.PredictionDeactivationTime) {
                PredictedPosition predictedPosition = prediction.Write(predictionTick);
                predictedPosition.X = x;
                predictedPosition.Y = y;
                predictedPosition.Tick = predictionTick++;
                if (x <= 0.0 || x >= this._battlefieldWidth || y <= 0.0 || y >= this._battlefieldHeight) {
                    prediction.PredictionDeactivationTime = predictionTick;
                    continue block0;
                }
                x += dX * predictedBulletVelocity;
                y += dY * predictedBulletVelocity;
            }
        }
    }
}

