/*
 * Decompiled with CFR 0.152.
 */
package synapse;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Vector;
import robocode.Rules;
import synapse.BaseBot;
import synapse.Enemy;
import synapse.GunAutoSegmented;
import synapse.Intel;
import synapse.Module;
import synapse.MovementAutoSegmented;
import synapse.SpotLight;

public class Geomancy
extends BaseBot {
    private Module movement;
    private Module gun;

    public void run() {
        this.location = new Point2D.Double(0.0, 0.0);
        this.oldLocation = new Point2D.Double(0.0, 0.0);
        this.oldOldLocation = new Point2D.Double(0.0, 0.0);
        this.movement = new MovementAutoSegmented(this);
        this.gun = new GunAutoSegmented(this);
        this.modules = new Vector(4);
        this.modules.add(new Intel(this));
        this.modules.add(new SpotLight(this));
        this.modules.add(this.movement);
        this.modules.add(this.gun);
        this.setColors(new Color(0, 0, 0), new Color(255, 77, 0), new Color(223, 218, 169), new Color(255, 255, 255), new Color(223, 218, 169));
        this.targets = new Hashtable();
        this.target = new Enemy();
        this.target.distance = 2.147483647E9;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (this.fighting) {
            super.updateInternalVars();
            for (Module m : this.modules) {
                m.tick();
            }
            this.execute();
        }
    }

    @Override
    public void onWin() {
        this.setAdjustGunForRobotTurn(false);
        this.setAdjustRadarForGunTurn(false);
        while (true) {
            super.updateInternalVars();
            this.setScanColor(Color.getHSBColor((float)Math.random(), 1.0f, 1.0f));
            this.setTurnRightRadians(Rules.MAX_TURN_RATE_RADIANS);
            this.setTurnGunRightRadians(Rules.GUN_TURN_RATE_RADIANS);
            this.setTurnRadarRightRadians(Rules.RADAR_TURN_RATE_RADIANS);
            this.movement.doTick();
            this.execute();
        }
    }

    public void onPaint(Graphics2D g) {
        g.setFont(g.getFont().deriveFont(12.0f));
        for (Module m : this.modules) {
            m.doPaint(g);
        }
    }
}

