/*
 * Decompiled with CFR 0.152.
 */
package amk.util;

public class Vector2d
implements Cloneable {
    public double xComponent;
    public double yComponent;

    public Vector2d() {
        this.xComponent = 0.0;
        this.yComponent = 0.0;
    }

    public Vector2d(double x, double y) {
        this.xComponent = x;
        this.yComponent = y;
    }

    public Vector2d(Vector2d v) {
        this.xComponent = v.xComponent;
        this.yComponent = v.yComponent;
    }

    public void add(Vector2d v) {
        this.xComponent += v.xComponent;
        this.yComponent += v.yComponent;
    }

    public double angle() {
        return Math.atan2(this.xComponent, this.yComponent);
    }

    public Object clone() {
        return new Vector2d(this);
    }

    public double dotProduct(Vector2d v) {
        return this.xComponent * v.xComponent + this.yComponent * v.yComponent;
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double magnitudeSquared() {
        return this.xComponent * this.xComponent + this.yComponent * this.yComponent;
    }

    public void normalize() {
        this.scale(1.0 / this.magnitude());
    }

    public void rotate(double rads) {
        double xNew = this.xComponent * Math.cos(rads) + this.yComponent * Math.sin(rads);
        double yNew = -this.xComponent * Math.sin(rads) + this.yComponent * Math.cos(rads);
        this.xComponent = xNew;
        this.yComponent = yNew;
    }

    public void scale(double s) {
        this.xComponent *= s;
        this.yComponent *= s;
    }

    public void subtract(Vector2d v) {
        this.xComponent -= v.xComponent;
        this.yComponent -= v.yComponent;
    }

    public String toString() {
        return "<" + this.xComponent + ", " + this.yComponent + ">";
    }
}

